/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SourceFolderImpl
extends ContentFolderBaseImpl
implements SourceFolder,
ClonableContentFolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.SimpleSourceFolderImpl");
    private boolean myIsTestSource;
    @NonNls
    public static final String ELEMENT_NAME = "sourceFolder";
    @NonNls
    public static final String TEST_SOURCE_ATTR = "isTestSource";
    private String myPackagePrefix;
    static final String DEFAULT_PACKAGE_PREFIX = "";
    @NonNls
    private static final String PACKAGE_PREFIX_ATTR = "packagePrefix";

    SourceFolderImpl(@NotNull VirtualFile file, boolean isTestSource, @NotNull ContentEntryImpl contentEntry) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        this(file, isTestSource, DEFAULT_PACKAGE_PREFIX, contentEntry);
    }

    SourceFolderImpl(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix, @NotNull ContentEntryImpl contentEntry) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        super(file, contentEntry);
        this.myIsTestSource = isTestSource;
        this.myPackagePrefix = packagePrefix;
    }

    public SourceFolderImpl(@NotNull String url, boolean isTestSource, @NotNull ContentEntryImpl contentEntry) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/impl/SourceFolderImpl.<init> must not be null");
        }
        super(url, contentEntry);
        this.myIsTestSource = isTestSource;
        this.myPackagePrefix = DEFAULT_PACKAGE_PREFIX;
    }

    SourceFolderImpl(Element element, ContentEntryImpl contentEntry) throws InvalidDataException {
        super(element, contentEntry);
        LOG.assertTrue(element.getName().equals(ELEMENT_NAME));
        String testSource = element.getAttributeValue(TEST_SOURCE_ATTR);
        if (testSource == null) {
            throw new InvalidDataException();
        }
        this.myIsTestSource = Boolean.valueOf(testSource);
        String packagePrefix = element.getAttributeValue(PACKAGE_PREFIX_ATTR);
        this.myPackagePrefix = packagePrefix != null ? packagePrefix : DEFAULT_PACKAGE_PREFIX;
    }

    private SourceFolderImpl(SourceFolderImpl that, ContentEntryImpl contentEntry) {
        super(that, contentEntry);
        this.myIsTestSource = that.myIsTestSource;
        this.myPackagePrefix = that.myPackagePrefix;
    }

    public boolean isTestSource() {
        return this.myIsTestSource;
    }

    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.myPackagePrefix = packagePrefix;
    }

    void writeExternal(Element element) {
        this.writeFolder(element, ELEMENT_NAME);
        element.setAttribute(TEST_SOURCE_ATTR, Boolean.toString(this.myIsTestSource));
        if (!DEFAULT_PACKAGE_PREFIX.equals(this.myPackagePrefix)) {
            element.setAttribute(PACKAGE_PREFIX_ATTR, this.myPackagePrefix);
        }
    }

    @Override
    public ContentFolder cloneFolder(ContentEntry contentEntry) {
        return new SourceFolderImpl(this, (ContentEntryImpl)contentEntry);
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        if (!(folder instanceof SourceFolderImpl)) {
            return -1;
        }
        int i = super.compareTo(folder);
        if (i != 0) {
            return i;
        }
        i = this.myPackagePrefix.compareTo(((SourceFolderImpl)folder).myPackagePrefix);
        if (i != 0) {
            return i;
        }
        return Boolean.valueOf(this.myIsTestSource).compareTo(((SourceFolderImpl)folder).myIsTestSource);
    }
}

