/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DoubleArrayList;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class ProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myIndeterminate;
    private final Stack<String> myTextStack = new Stack(2);
    private final DoubleArrayList myFractionStack = new DoubleArrayList(2);
    private final Stack<String> myText2Stack = new Stack(2);
    private volatile int myNonCancelableCount = 0;
    private ProgressIndicator myModalityProgress = null;
    private ModalityState myModalityState = ModalityState.NON_MODAL;
    private boolean myModalityEntered = false;
    private final CopyOnWriteArrayList<ProgressIndicatorEx> myStateDelegates = ContainerUtil.createEmptyCOWList();
    private final WeakList<TaskInfo> myFinished = new WeakList();
    private boolean myWasStarted;
    private TaskInfo myOwnerTask;
    private static final IndicatorAction CHECK_CANCELED_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.checkCanceled();
        }
    };
    private static final IndicatorAction STOP_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.stop();
        }
    };
    private static final IndicatorAction START_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.start();
        }
    };
    private static final IndicatorAction CANCEL_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.cancel();
        }
    };
    private static final IndicatorAction PUSH_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.pushState();
        }
    };
    private static final IndicatorAction POP_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.popState();
        }
    };
    private static final IndicatorAction STARTNC_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.startNonCancelableSection();
        }
    };
    private static final IndicatorAction FINISHNC_ACTION = new IndicatorAction(){

        @Override
        public void execute(ProgressIndicatorEx each) {
            each.finishNonCancelableSection();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProgressIndicatorBase progressIndicatorBase = this;
        synchronized (progressIndicatorBase) {
            LOG.assertTrue(!this.isRunning(), (Object)"Attempt to start ProgressIndicator which is already running");
            this.myText = "";
            this.myFraction = 0.0;
            this.myText2 = "";
            this.myCanceled = false;
            this.myRunning = true;
            this.myWasStarted = true;
            this.delegateRunningChange(START_ACTION);
        }
        this.enterModality();
    }

    protected final void enterModality() {
        if (this.myModalityProgress == this) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressIndicatorBase.this.doEnterModality();
                }
            });
        }
    }

    private void doEnterModality() {
        if (!this.myModalityEntered) {
            LaterInvocator.enterModal(this);
            this.myModalityEntered = true;
        }
    }

    public void stop() {
        LOG.assertTrue(this.myRunning, (Object)"stop() should be called only if start() called before");
        this.myRunning = false;
        this.delegateRunningChange(STOP_ACTION);
        this.exitModality();
    }

    protected final void exitModality() {
        if (this.myModalityProgress == this) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressIndicatorBase.this.doExitModality();
                }
            });
        }
    }

    private void doExitModality() {
        if (this.myModalityEntered) {
            LaterInvocator.leaveModal(this);
            this.myModalityEntered = false;
        }
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    public void cancel() {
        this.myCanceled = true;
        ProgressManagerImpl.canceled();
        this.delegateRunningChange(CANCEL_ACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(final @NotNull TaskInfo task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/util/ProgressIndicatorBase.finish must not be null");
        }
        WeakList<TaskInfo> weakList = this.myFinished;
        synchronized (weakList) {
            if (this.myFinished.contains((Object)task)) {
                return;
            }
            this.myFinished.add((Object)task);
        }
        this.delegateRunningChange(new IndicatorAction(){

            @Override
            public void execute(ProgressIndicatorEx each) {
                each.finish(task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished(@NotNull TaskInfo task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/util/ProgressIndicatorBase.isFinished must not be null");
        }
        WeakList<TaskInfo> weakList = this.myFinished;
        synchronized (weakList) {
            return this.myFinished.contains((Object)task);
        }
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
        }
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    public final void checkCanceled() {
        if (this.isCanceled() && this.myNonCancelableCount == 0) {
            throw new ProcessCanceledException();
        }
        this.delegate(CHECK_CANCELED_ACTION);
    }

    public void setText(final String text) {
        this.myText = text;
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(ProgressIndicatorEx each) {
                each.setText(text);
            }
        });
    }

    public String getText() {
        return this.myText;
    }

    public void setText2(final String text) {
        this.myText2 = text;
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(ProgressIndicatorEx each) {
                each.setText2(text);
            }
        });
    }

    public String getText2() {
        return this.myText2;
    }

    public double getFraction() {
        return this.myFraction;
    }

    public void setFraction(final double fraction) {
        this.myFraction = fraction;
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(ProgressIndicatorEx each) {
                each.setFraction(fraction);
            }
        });
    }

    public synchronized void pushState() {
        this.myTextStack.push((Object)this.myText);
        this.myFractionStack.add(this.myFraction);
        this.myText2Stack.push((Object)this.myText2);
        this.delegateProgressChange(PUSH_ACTION);
    }

    public synchronized void popState() {
        LOG.assertTrue(!this.myTextStack.isEmpty());
        String oldText = (String)this.myTextStack.pop();
        double oldFraction = this.myFractionStack.remove(this.myFractionStack.size() - 1);
        String oldText2 = (String)this.myText2Stack.pop();
        this.setText(oldText);
        this.setFraction(oldFraction);
        this.setText2(oldText2);
        this.delegateProgressChange(POP_ACTION);
    }

    public void startNonCancelableSection() {
        ++this.myNonCancelableCount;
        this.delegateProgressChange(STARTNC_ACTION);
    }

    public void finishNonCancelableSection() {
        --this.myNonCancelableCount;
        this.delegateProgressChange(FINISHNC_ACTION);
    }

    protected boolean isCancelable() {
        return this.myNonCancelableCount == 0;
    }

    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    public final ModalityState getModalityState() {
        return this.myModalityState;
    }

    public void setModalityProgress(ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        ModalityState currentModality = ApplicationManager.getApplication().getCurrentModalityState();
        this.myModalityState = this.myModalityProgress != null ? ((ModalityStateEx)currentModality).appendProgress(this.myModalityProgress) : currentModality;
    }

    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    public void setIndeterminate(final boolean indeterminate) {
        this.myIndeterminate = indeterminate;
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(ProgressIndicatorEx each) {
                each.setIndeterminate(indeterminate);
            }
        });
    }

    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/util/ProgressIndicatorBase.addStateDelegate must not be null");
        }
        delegate.initStateFrom(this);
        this.myStateDelegates.addIfAbsent(delegate);
    }

    private void delegateProgressChange(IndicatorAction action) {
        this.delegate(action);
        this.onProgressChange();
    }

    private void delegateRunningChange(IndicatorAction action) {
        this.delegate(action);
        this.onRunningChange();
    }

    private void delegate(IndicatorAction action) {
        for (ProgressIndicatorEx each : this.myStateDelegates) {
            action.execute(each);
        }
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    @NotNull
    public Stack<String> getTextStack() {
        Stack<String> stack = this.myTextStack;
        if (stack == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/progress/util/ProgressIndicatorBase.getTextStack must not return null");
        }
        return stack;
    }

    @Override
    @NotNull
    public DoubleArrayList getFractionStack() {
        DoubleArrayList doubleArrayList = this.myFractionStack;
        if (doubleArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/progress/util/ProgressIndicatorBase.getFractionStack must not return null");
        }
        return doubleArrayList;
    }

    @Override
    @NotNull
    public Stack<String> getText2Stack() {
        Stack<String> stack = this.myText2Stack;
        if (stack == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/progress/util/ProgressIndicatorBase.getText2Stack must not return null");
        }
        return stack;
    }

    @Override
    public int getNonCancelableCount() {
        return this.myNonCancelableCount;
    }

    @Override
    public boolean isModalityEntered() {
        return this.myModalityEntered;
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    @Override
    public synchronized void initStateFrom(@NotNull ProgressIndicatorEx indicator) {
        double[] fractions;
        if (indicator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/util/ProgressIndicatorBase.initStateFrom must not be null");
        }
        this.myRunning = indicator.isRunning();
        this.myCanceled = indicator.isCanceled();
        this.myModalityEntered = indicator.isModalityEntered();
        this.myFraction = indicator.getFraction();
        this.myIndeterminate = indicator.isIndeterminate();
        this.myNonCancelableCount = indicator.getNonCancelableCount();
        this.myTextStack.clear();
        this.myTextStack.addAll(indicator.getTextStack());
        this.myText = indicator.getText();
        this.myText2Stack.clear();
        this.myText2Stack.addAll(indicator.getText2Stack());
        this.myText2 = indicator.getText2();
        this.myFractionStack.clear();
        for (double eachFraction : fractions = indicator.getFractionStack().toArray()) {
            this.myFractionStack.add(eachFraction);
        }
        this.myFraction = indicator.getFraction();
    }

    private static interface IndicatorAction {
        public void execute(ProgressIndicatorEx var1);
    }
}

