/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractColorsScheme
implements EditorColorsScheme {
    protected EditorColorsScheme myParentScheme;
    protected int myEditorFontSize;
    protected float myLineSpacing;
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);
    private String myEditorFontName;
    private String myFallbackFontName;
    private String mySchemeName;
    private int myVersion;
    protected Map<ColorKey, Color> myColorsMap = new HashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = new HashMap();
    @NonNls
    private static final String DEFAULT_FONT_NAME = "Courier";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    protected static final String SCHEME_NAME = "SCHEME_NAME";
    protected DefaultColorSchemesManager myDefaultColorSchemesManager;
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    protected static final String DEFAULT_SCHEME_NAME = "Default";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    private static final Map<String, Color> DEFAULT_ERROR_STRIPE_COLOR = new THashMap();

    protected AbstractColorsScheme(EditorColorsScheme parentScheme, DefaultColorSchemesManager defaultColorSchemesManager) {
        this.myParentScheme = parentScheme;
        this.myDefaultColorSchemesManager = defaultColorSchemesManager;
    }

    public AbstractColorsScheme(DefaultColorSchemesManager defaultColorSchemesManager) {
        this.myDefaultColorSchemesManager = defaultColorSchemesManager;
    }

    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        return c != null ? c : Color.white;
    }

    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        return c != null ? c : Color.black;
    }

    public String getName() {
        return this.mySchemeName;
    }

    public void setFont(EditorFontType key, Font font) {
        this.myFonts.put(key, font);
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        newScheme.myEditorFontSize = this.myEditorFontSize;
        newScheme.myLineSpacing = this.myLineSpacing;
        newScheme.setEditorFontName(this.getEditorFontName());
        Set<EditorFontType> types = this.myFonts.keySet();
        for (EditorFontType type : types) {
            Font font = this.myFonts.get(type);
            newScheme.setFont(type, font);
        }
        newScheme.myAttributesMap = new HashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    public void setEditorFontName(String fontName) {
        this.myEditorFontName = fontName;
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        this.myEditorFontSize = fontSize;
        this.initFonts();
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = lineSpacing;
    }

    public Font getFont(EditorFontType key) {
        return this.myFonts.get(key);
    }

    public void setName(String name) {
        this.mySchemeName = name;
    }

    public String getEditorFontName() {
        if (this.myFallbackFontName != null) {
            return this.myFallbackFontName;
        }
        return this.myEditorFontName == null ? DEFAULT_FONT_NAME : this.myEditorFontName;
    }

    public int getEditorFontSize() {
        return this.myEditorFontSize;
    }

    public float getLineSpacing() {
        return this.myLineSpacing <= 0.0f ? 1.0f : this.myLineSpacing;
    }

    protected void initFonts() {
        int editorFontSize;
        String editorFontName = this.getEditorFontName();
        Font plainFont = new Font(editorFontName, 0, editorFontSize = this.getEditorFontSize());
        if (plainFont.getFamily().equals("Dialog") && !editorFontName.equals("Dialog")) {
            this.myFallbackFontName = editorFontName = this.myParentScheme != null ? this.myParentScheme.getEditorFontName() : DEFAULT_FONT_NAME;
            plainFont = new Font(editorFontName, 0, editorFontSize);
        } else {
            this.myFallbackFontName = null;
        }
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
    }

    public String toString() {
        return this.getName();
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            for (Object o : parentNode.getChildren(SCHEME_ELEMENT)) {
                Element element = (Element)o;
                this.readScheme(element);
            }
        }
        this.initFonts();
    }

    private void readScheme(Element node) throws InvalidDataException {
        this.myDeprecatedBackgroundColor = null;
        if (SCHEME_ELEMENT.equals(node.getName())) {
            this.setName(node.getAttributeValue(NAME_ATTR));
            this.myVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
            String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
            if (isDefaultScheme == null || !Boolean.parseBoolean(isDefaultScheme)) {
                String parentSchemeName = node.getAttributeValue(PARENT_SCHEME_ATTR);
                if (parentSchemeName == null) {
                    parentSchemeName = DEFAULT_SCHEME_NAME;
                }
                this.myParentScheme = this.myDefaultColorSchemesManager.getScheme(parentSchemeName);
            }
            for (Object o : node.getChildren()) {
                Element childNode = (Element)o;
                if (OPTION_ELEMENT.equals(childNode.getName())) {
                    this.readSettings(childNode);
                    continue;
                }
                if (COLORS_ELEMENT.equals(childNode.getName())) {
                    this.readColors(childNode);
                    continue;
                }
                if (!ATTRIBUTES_ELEMENT.equals(childNode.getName())) continue;
                this.readAttributes(childNode);
            }
            if (this.myDeprecatedBackgroundColor != null) {
                TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
                if (textAttributes == null) {
                    textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                    this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
                } else {
                    textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
                }
            }
            this.initFonts();
        }
    }

    private void readAttributes(Element childNode) throws InvalidDataException {
        for (Object o : childNode.getChildren(OPTION_ELEMENT)) {
            Element e = (Element)o;
            String key = e.getAttributeValue(NAME_ATTR);
            TextAttributesKey name = TextAttributesKey.find((String)key);
            TextAttributes attr = new TextAttributes();
            Element value = e.getChild(VALUE_ELEMENT);
            attr.readExternal(value);
            this.myAttributesMap.put(name, attr);
            this.migrateErrorStripeColorFrom45(name, attr);
        }
    }

    private void migrateErrorStripeColorFrom45(TextAttributesKey name, TextAttributes attr) {
        if (this.myVersion != 0) {
            return;
        }
        Color defaultColor = DEFAULT_ERROR_STRIPE_COLOR.get(name.getExternalName());
        if (defaultColor != null && attr.getErrorStripeColor() == null) {
            attr.setErrorStripeColor(defaultColor);
        }
    }

    private void readColors(Element childNode) {
        for (Object o : childNode.getChildren(OPTION_ELEMENT)) {
            Element colorElement = (Element)o;
            Color valueColor = AbstractColorsScheme.readColorValue(colorElement);
            String colorName = colorElement.getAttributeValue(NAME_ATTR);
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private static Color readColorValue(Element colorElement) {
        String value = colorElement.getAttributeValue(VALUE_ELEMENT);
        Color valueColor = null;
        if (value != null && value.trim().length() > 0) {
            try {
                valueColor = new Color(Integer.parseInt(value, 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return valueColor;
    }

    private void readSettings(Element childNode) {
        String name = childNode.getAttributeValue(NAME_ATTR);
        String value = childNode.getAttributeValue(VALUE_ELEMENT);
        if (LINE_SPACING.equals(name)) {
            this.myLineSpacing = Float.parseFloat(value);
        } else if (EDITOR_FONT_SIZE.equals(name)) {
            this.myEditorFontSize = Integer.parseInt(value);
        } else if (EDITOR_FONT_NAME.equals(name)) {
            this.setEditorFontName(value);
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        parentNode.setAttribute(NAME_ATTR, this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (this.myParentScheme != null) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        Element element = new Element(OPTION_ELEMENT);
        element.setAttribute(NAME_ATTR, LINE_SPACING);
        element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getLineSpacing()));
        parentNode.addContent(element);
        element = new Element(OPTION_ELEMENT);
        element.setAttribute(NAME_ATTR, EDITOR_FONT_SIZE);
        element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getEditorFontSize()));
        parentNode.addContent(element);
        element = new Element(OPTION_ELEMENT);
        element.setAttribute(NAME_ATTR, EDITOR_FONT_NAME);
        element.setAttribute(VALUE_ELEMENT, this.getEditorFontName());
        parentNode.addContent(element);
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        parentNode.addContent(colorElements);
        parentNode.addContent(attrElements);
    }

    private boolean haveToWrite(TextAttributesKey key, TextAttributes value, TextAttributes defaultAttribute) {
        boolean hasDefaultValue = value.equals((Object)defaultAttribute);
        if (this.myParentScheme == null) {
            return !hasDefaultValue;
        }
        if (EditorColorsManager.getInstance().getGlobalScheme() == this && this.myParentScheme instanceof AbstractColorsScheme && !((AbstractColorsScheme)this.myParentScheme).myAttributesMap.containsKey(key)) {
            return true;
        }
        return !value.equals((Object)this.myParentScheme.getAttributes(key));
    }

    private void writeAttributes(Element attrElements) throws WriteExternalException {
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        Collections.sort(list);
        TextAttributes defaultAttr = new TextAttributes();
        for (TextAttributesKey key : list) {
            TextAttributes value;
            if (!this.haveToWrite(key, value = this.myAttributesMap.get(key), defaultAttr)) continue;
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, key.getExternalName());
            Element valueElement = new Element(VALUE_ELEMENT);
            value.writeExternal(valueElement);
            element.addContent(valueElement);
            attrElements.addContent(element);
        }
    }

    protected Color getOwnColor(ColorKey key) {
        return this.myColorsMap.get(key);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        Collections.sort(list);
        for (ColorKey key : list) {
            if (!this.haveToWrite(key)) continue;
            Color value = this.myColorsMap.get(key);
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, key.getExternalName());
            element.setAttribute(VALUE_ELEMENT, value != null ? Integer.toString(value.getRGB() & 0xFFFFFF, 16) : "");
            colorElements.addContent(element);
        }
    }

    private boolean haveToWrite(ColorKey key) {
        Color value = this.myColorsMap.get(key);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal((Object)((AbstractColorsScheme)this.myParentScheme).getOwnColor(key), (Object)value) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key) : Comparing.equal((Object)this.myParentScheme.getColor(key), (Object)value));
    }

    static {
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Color.red);
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES.getExternalName(), Color.red);
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Color.yellow);
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.INFO_ATTRIBUTES.getExternalName(), Color.yellow.brighter());
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getExternalName(), Color.yellow);
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getExternalName(), Color.yellow);
        DEFAULT_ERROR_STRIPE_COLOR.put(CodeInsightColors.DEPRECATED_ATTRIBUTES.getExternalName(), Color.yellow);
    }
}

