/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

class SimpleChange
extends Change
implements DiffRangeMarker.RangeInvalidListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.Change");
    private final ChangeType myType;
    private final Change.Side[] mySides;
    private final ChangeList myChangeList;

    public SimpleChange(ChangeType type, @NotNull TextRange range1, @NotNull TextRange range2, ChangeList changeList) {
        if (range1 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/SimpleChange.<init> must not be null");
        }
        if (range2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/SimpleChange.<init> must not be null");
        }
        this.mySides = new Change.Side[]{this.createSide(changeList, range1, FragmentSide.SIDE1), this.createSide(changeList, range2, FragmentSide.SIDE2)};
        this.myType = type;
        this.myChangeList = changeList;
    }

    private Change.Side createSide(ChangeList changeList, TextRange range1, FragmentSide side) {
        return new Change.Side(side, new DiffRangeMarker((DocumentEx)changeList.getDocument(side), range1, this));
    }

    @Override
    protected void removeFromList() {
        this.myChangeList.remove(this);
    }

    @Override
    public ChangeType.ChangeSide getChangeSide(FragmentSide side) {
        return this.mySides[side.getIndex()];
    }

    @Override
    public ChangeType getType() {
        return this.myType;
    }

    @Override
    public ChangeList getChangeList() {
        return this.myChangeList;
    }

    @Override
    public void onRemovedFromList() {
        for (int i = 0; i < this.mySides.length; ++i) {
            Change.Side side = this.mySides[i];
            side.getRange().removeListener(this);
            side.getHighlighterHolder().removeHighlighters();
            this.mySides[i] = null;
        }
    }

    @Override
    public boolean isValid() {
        LOG.assertTrue(this.mySides[0] == null == (this.mySides[1] == null));
        return this.mySides[0] != null;
    }

    @Override
    public void onRangeInvalidated() {
        this.myChangeList.remove(this);
    }

    public static Change fromRanges(@NotNull TextRange baseRange, @NotNull TextRange versionRange, ChangeList changeList) {
        if (baseRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/SimpleChange.fromRanges must not be null");
        }
        if (versionRange == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/SimpleChange.fromRanges must not be null");
        }
        ChangeType type = ChangeType.fromRanges(baseRange, versionRange);
        return new SimpleChange(type, baseRange, versionRange, changeList);
    }
}

