/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationSettings {
    private NotificationDisplayType myDisplayType;
    private String myGroupId;

    public NotificationSettings(String groupId, NotificationDisplayType displayType) {
        this.myGroupId = groupId;
        this.myDisplayType = displayType;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationSettings.getGroupId must not return null");
        }
        return string;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        NotificationDisplayType notificationDisplayType = this.myDisplayType;
        if (notificationDisplayType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationSettings.getDisplayType must not return null");
        }
        return notificationDisplayType;
    }

    @Nullable
    public static NotificationSettings load(@NotNull Element element) {
        String groupId;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationSettings.load must not be null");
        }
        String displayTypeString = element.getAttributeValue("displayType");
        NotificationDisplayType displayType = NotificationDisplayType.BALLOON;
        if (displayTypeString != null) {
            try {
                displayType = NotificationDisplayType.valueOf((String)displayTypeString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                displayType = NotificationDisplayType.BALLOON;
            }
        }
        return (groupId = element.getAttributeValue("groupId")) != null ? new NotificationSettings(groupId, displayType) : null;
    }

    @NotNull
    public Element save() {
        Element result = new Element("notification");
        result.setAttribute("groupId", this.getGroupId());
        result.setAttribute("displayType", this.getDisplayType().toString());
        Element element = result;
        if (element == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationSettings.save must not return null");
        }
        return element;
    }

    public void setDisplayType(NotificationDisplayType displayType) {
        this.myDisplayType = displayType;
    }
}

