/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Font;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class GotoFileCellRenderer
extends PsiElementListCellRenderer<PsiFile> {
    private final int myMaxWidth;

    public GotoFileCellRenderer(int maxSize) {
        this.myMaxWidth = maxSize;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font editorFont = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
        this.setFont(editorFont);
    }

    @Override
    public String getElementText(PsiFile element) {
        return element.getName();
    }

    @Override
    protected String getContainerText(PsiFile element, String name) {
        PsiDirectory psiDirectory = element.getContainingDirectory();
        if (psiDirectory == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        String relativePath = GotoFileCellRenderer.getRelativePath(virtualFile, element.getProject());
        if (relativePath == null) {
            return "( " + File.separator + " )";
        }
        String path = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(name + "          ", new File(relativePath), (JComponent)this, this.myMaxWidth);
        return "(" + path + ")";
    }

    @Nullable
    private static String getRelativePath(VirtualFile virtualFile, Project project) {
        String projectHomeUrl;
        String url = virtualFile.getPresentableUrl();
        if (project == null) {
            return url;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            String cont = url.substring(projectHomeUrl.length());
            if (cont.length() == 0) {
                return null;
            }
            url = "..." + cont;
        }
        return url;
    }

    @Override
    protected int getIconFlags() {
        return 0;
    }
}

