/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.ide.structureView.impl.StructureViewState;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.StructureTreeBuilder;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StructureViewComponent
extends SimpleToolWindowPanel
implements TreeActionsOwner,
DataProvider,
StructureView.Scrollable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.structureView.newStructureView.StructureViewComponent");
    @NonNls
    private static final String ourHelpID = "viewingStructure.fileStructureView";
    private StructureTreeBuilder myAbstractTreeBuilder;
    private FileEditor myFileEditor;
    private final TreeModelWrapper myTreeModelWrapper;
    private StructureViewState myStructureViewState;
    private boolean myAutoscrollFeedback;
    private final Alarm myAutoscrollAlarm = new Alarm();
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final MyAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final AutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private static final Key<StructureViewState> STRUCTURE_VIEW_STATE_KEY = Key.create((String)"STRUCTURE_VIEW_STATE");
    private final Project myProject;
    private final StructureViewModel myTreeModel;
    private static int ourSettingsModificationCount;
    private JTree myTree;

    public StructureViewComponent(FileEditor editor, StructureViewModel structureViewModel, Project project) {
        this(editor, structureViewModel, project, true);
    }

    public StructureViewComponent(FileEditor editor, StructureViewModel structureViewModel, Project project, boolean showRootNode) {
        super(true, true);
        this.myProject = project;
        this.myFileEditor = editor;
        this.myTreeModel = structureViewModel;
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this);
        SmartTreeStructure treeStructure = new SmartTreeStructure(project, (TreeModel)this.myTreeModelWrapper){

            @Override
            public void rebuildTree() {
                if (!StructureViewComponent.this.isDisposed()) {
                    super.rebuildTree();
                }
            }

            public boolean isToBuildChildrenInBackground(Object element) {
                return this.getRootElement() == element;
            }

            @Override
            protected TreeElementWrapper createTree() {
                return new StructureViewTreeElementWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
            }
        };
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(treeStructure.getRootElement()));
        this.myTree = new Tree((javax.swing.tree.TreeModel)model);
        this.myTree.setRootVisible(showRootNode);
        this.myTree.setShowsRootHandles(true);
        this.myAbstractTreeBuilder = new StructureTreeBuilder(project, this.myTree, (DefaultTreeModel)this.myTree.getModel(), treeStructure, this.myTreeModelWrapper){

            protected boolean validateNode(Object child) {
                return StructureViewComponent.isValid(child);
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myAbstractTreeBuilder);
        Disposer.register((Disposable)this.myAbstractTreeBuilder, (Disposable)new Disposable(){

            public void dispose() {
                StructureViewComponent.this.storeState();
            }
        });
        this.setContent(new JScrollPane(this.myAbstractTreeBuilder.getTree()));
        this.myAbstractTreeBuilder.getTree().setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myAutoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler(this.myProject, (Disposable)this);
        JComponent toolbarComponent = ActionManager.getInstance().createActionToolbar("StructureViewToolbar", this.createActionGroup(), true).getComponent();
        this.setToolbar(toolbarComponent);
        this.installTree();
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this.getTree()){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray = StructureViewComponent.this.getSelectedPsiElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureViewComponent$4.getSelectedElements must not return null");
                }
                return psiElementArray;
            }
        };
    }

    private void installTree() {
        this.getTree().getSelectionModel().setSelectionMode(4);
        this.myAutoScrollToSourceHandler.install(this.getTree());
        this.myAutoScrollFromSourceHandler.install();
        TreeToolTipHandler.install(this.getTree());
        TreeUtil.installActions((JTree)this.getTree());
        new TreeSpeedSearch(this.getTree());
        this.addTreeKeyListener();
        this.addTreeMouseListeners();
        this.restoreState();
    }

    private PsiElement[] getSelectedPsiElements() {
        return StructureViewComponent.filterPsiElements(this.getSelectedElements());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiElement[] filterPsiElements(Object[] selectedElements) {
        PsiElement[] psiElementArray;
        if (selectedElements == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureViewComponent.filterPsiElements must not return null");
            return psiElementArray;
        }
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (Object selectedElement : selectedElements) {
            if (!(selectedElement instanceof PsiElement)) continue;
            psiElements.add((PsiElement)selectedElement);
        }
        psiElementArray = psiElements.toArray(new PsiElement[psiElements.size()]);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureViewComponent.filterPsiElements must not return null");
    }

    private Object[] getSelectedElements() {
        JTree tree = this.getTree();
        return tree != null ? StructureViewComponent.convertPathsToValues(tree.getSelectionPaths()) : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private Object[] getSelectedTreeElements() {
        return StructureViewComponent.convertPathsToTreeElements(this.getTree().getSelectionPaths());
    }

    private static Object[] convertPathsToValues(TreePath[] selectionPaths) {
        if (selectionPaths != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (TreePath selectionPath : selectionPaths) {
                Object userObject = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
                if (!(userObject instanceof AbstractTreeNode)) continue;
                Object value = ((AbstractTreeNode)userObject).getValue();
                if (value instanceof StructureViewTreeElement) {
                    value = ((StructureViewTreeElement)value).getValue();
                }
                result.add(value);
            }
            return ArrayUtil.toObjectArray(result);
        }
        return null;
    }

    private static Object[] convertPathsToTreeElements(TreePath[] selectionPaths) {
        if (selectionPaths != null) {
            Object[] result = new Object[selectionPaths.length];
            for (int i = 0; i < selectionPaths.length; ++i) {
                Object userObject = ((DefaultMutableTreeNode)selectionPaths[i].getLastPathComponent()).getUserObject();
                if (!(userObject instanceof AbstractTreeNode)) {
                    return null;
                }
                result[i] = ((AbstractTreeNode)userObject).getValue();
            }
            return result;
        }
        return null;
    }

    private void addTreeMouseListeners() {
        EditSourceOnDoubleClickHandler.install((JTree)this.getTree());
        CustomizationUtil.installPopupHandler(this.getTree(), "StructureViewPopupMenu", "StructureViewPopup");
    }

    private void addTreeKeyListener() {
        this.getTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)StructureViewComponent.this.getTree());
                    OpenSourceUtil.openSourcesFrom((DataContext)dataContext, (boolean)false);
                } else if (27 == e.getKeyCode()) {
                    boolean[] isCopied;
                    if (e.isConsumed()) {
                        return;
                    }
                    PsiCopyPasteManager copyPasteManager = PsiCopyPasteManager.getInstance();
                    if (copyPasteManager.getElements(isCopied = new boolean[1]) != null && !isCopied[0]) {
                        copyPasteManager.clear();
                        e.consume();
                    }
                }
            }
        });
    }

    public void storeState() {
        if (!this.isDisposed()) {
            this.myStructureViewState = this.getState();
            this.myFileEditor.putUserData(STRUCTURE_VIEW_STATE_KEY, (Object)this.myStructureViewState);
        }
    }

    public StructureViewState getState() {
        StructureViewState structureViewState = new StructureViewState();
        if (this.getTree() != null) {
            structureViewState.setExpandedElements(this.getExpandedElements());
            structureViewState.setSelectedElements(this.getSelectedElements());
        }
        return structureViewState;
    }

    private Object[] getExpandedElements() {
        JTree tree = this.getTree();
        if (tree == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List expandedPaths = TreeUtil.collectExpandedPaths((JTree)tree);
        return StructureViewComponent.convertPathsToValues(expandedPaths.toArray(new TreePath[expandedPaths.size()]));
    }

    public void restoreState() {
        this.myStructureViewState = (StructureViewState)this.myFileEditor.getUserData(STRUCTURE_VIEW_STATE_KEY);
        if (this.myStructureViewState == null) {
            TreeUtil.expand((JTree)this.getTree(), (int)2);
        } else {
            this.expandStoredElements();
            this.selectStoredElements();
            this.myFileEditor.putUserData(STRUCTURE_VIEW_STATE_KEY, null);
            this.myStructureViewState = null;
        }
    }

    private void selectStoredElements() {
        Object[] selectedPsiElements = null;
        if (this.myStructureViewState != null) {
            selectedPsiElements = this.myStructureViewState.getSelectedElements();
        }
        if (selectedPsiElements == null) {
            this.getTree().setSelectionPath(new TreePath(this.getRootNode().getPath()));
        } else {
            for (Object element : selectedPsiElements) {
                if (element instanceof PsiElement && !((PsiElement)element).isValid()) continue;
                this.addSelectionPathTo(element);
            }
        }
    }

    public void addSelectionPathTo(Object element) {
        DefaultMutableTreeNode node = this.myAbstractTreeBuilder.getNodeForElement(element);
        if (node != null) {
            JTree tree = this.getTree();
            TreePath path = new TreePath(node.getPath());
            if (node == tree.getModel().getRoot() && !tree.isExpanded(path)) {
                tree.expandPath(path);
            }
            tree.addSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getTree().getModel().getRoot();
    }

    private void expandStoredElements() {
        Object[] expandedPsiElements = null;
        if (this.myStructureViewState != null) {
            expandedPsiElements = this.myStructureViewState.getExpandedElements();
        }
        if (expandedPsiElements == null) {
            this.getTree().expandPath(new TreePath(this.getRootNode().getPath()));
        } else {
            for (Object element : expandedPsiElements) {
                if (element instanceof PsiElement && !((PsiElement)element).isValid()) continue;
                this.expandPathToElement(element);
            }
        }
    }

    protected ActionGroup createActionGroup() {
        Filter[] filters;
        Grouper[] groupers;
        Sorter[] sorters;
        DefaultActionGroup result = new DefaultActionGroup();
        for (Sorter sorter : sorters = this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            result.add((AnAction)new TreeActionWrapper((TreeAction)sorter, this));
        }
        if (sorters.length > 0) {
            result.addSeparator();
        }
        for (Grouper grouper : groupers = this.myTreeModel.getGroupers()) {
            result.add((AnAction)new TreeActionWrapper((TreeAction)grouper, this));
        }
        for (Filter filter : filters = this.myTreeModel.getFilters()) {
            result.add((AnAction)new TreeActionWrapper((TreeAction)filter, this));
        }
        if (this.showScrollToFromSourceActions()) {
            result.addSeparator();
            result.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
            result.add((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction());
        }
        result.addSeparator();
        result.add((AnAction)new ContextHelpAction(this.getHelpID()));
        return result;
    }

    protected boolean showScrollToFromSourceActions() {
        return true;
    }

    public FileEditor getFileEditor() {
        return this.myFileEditor;
    }

    public AsyncResult<AbstractTreeNode> expandPathToElement(Object element) {
        if (this.myAbstractTreeBuilder == null) {
            return new AsyncResult.Rejected();
        }
        ArrayList<AbstractTreeNode> pathToElement = this.getPathToElement(element);
        if (pathToElement.isEmpty()) {
            return new AsyncResult.Rejected();
        }
        final AsyncResult result = new AsyncResult();
        final AbstractTreeNode toExpand = pathToElement.get(pathToElement.size() - 1);
        this.myAbstractTreeBuilder.expand(toExpand, new Runnable(){

            @Override
            public void run() {
                result.setDone((Object)toExpand);
            }
        });
        return result;
    }

    public boolean select(final Object element, final boolean requestFocus) {
        this.myAbstractTreeBuilder.getReady(this).doWhenDone(new Runnable(){

            @Override
            public void run() {
                StructureViewComponent.this.expandPathToElement(element).doWhenDone((AsyncResult.Handler)new AsyncResult.Handler<AbstractTreeNode>(){

                    public void run(AbstractTreeNode abstractTreeNode) {
                        StructureViewComponent.this.myAbstractTreeBuilder.select(abstractTreeNode, new Runnable(){

                            @Override
                            public void run() {
                                if (requestFocus) {
                                    IdeFocusManager.getInstance((Project)StructureViewComponent.this.myProject).requestFocus((Component)StructureViewComponent.this.myAbstractTreeBuilder.getTree(), false);
                                }
                            }
                        });
                    }
                });
            }
        });
        return true;
    }

    private ArrayList<AbstractTreeNode> getPathToElement(Object element) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        StructureViewComponent.addToPath((AbstractTreeNode)this.myAbstractTreeBuilder.getTreeStructure().getRootElement(), element, result, (Collection<Object>)new THashSet());
        return result;
    }

    private static boolean addToPath(AbstractTreeNode<?> rootElement, Object element, ArrayList<AbstractTreeNode> result, Collection<Object> processedElements) {
        Object value = rootElement.getValue();
        if (value instanceof StructureViewTreeElement) {
            value = ((StructureViewTreeElement)value).getValue();
        }
        if (!processedElements.add(value)) {
            return false;
        }
        if (Comparing.equal((Object)value, (Object)element)) {
            result.add(0, rootElement);
            return true;
        }
        Collection children = rootElement.getChildren();
        for (AbstractTreeNode child : children) {
            if (!StructureViewComponent.addToPath(child, element, result, processedElements)) continue;
            result.add(0, rootElement);
            return true;
        }
        return false;
    }

    private static DefaultMutableTreeNode findInChildren(DefaultMutableTreeNode currentTreeNode, AbstractTreeNode topPathElement) {
        for (int i = 0; i < currentTreeNode.getChildCount(); ++i) {
            TreeNode child = currentTreeNode.getChildAt(i);
            if (!((DefaultMutableTreeNode)child).getUserObject().equals(topPathElement)) continue;
            return (DefaultMutableTreeNode)child;
        }
        return null;
    }

    private void scrollToSelectedElement() {
        if (this.myAutoscrollFeedback) {
            this.myAutoscrollFeedback = false;
            return;
        }
        StructureViewFactoryImpl structureViewFactory = (StructureViewFactoryImpl)StructureViewFactoryEx.getInstance((Project)this.myProject);
        if (!structureViewFactory.getState().AUTOSCROLL_FROM_SOURCE) {
            return;
        }
        this.myAutoscrollAlarm.cancelAllRequests();
        this.myAutoscrollAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (StructureViewComponent.this.myAbstractTreeBuilder == null) {
                    return;
                }
                StructureViewComponent.this.selectViewableElement();
            }
        }, 1000);
    }

    private void selectViewableElement() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Object currentEditorElement = this.myTreeModel.getCurrentEditorElement();
        if (currentEditorElement != null) {
            this.select(currentEditorElement, false);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)Thread.currentThread().getName());
        this.myAbstractTreeBuilder = null;
        this.myTreeModelWrapper.dispose();
        this.myFileEditor = null;
    }

    public boolean isDisposed() {
        return this.myAbstractTreeBuilder == null;
    }

    public void centerSelectedRow() {
        TreePath path = this.getTree().getSelectionPath();
        if (path == null) {
            return;
        }
        this.myAutoScrollToSourceHandler.setShouldAutoScroll(false);
        TreeUtil.showRowCentered((JTree)this.getTree(), (int)this.getTree().getRowForPath(path), (boolean)false);
        this.myAutoScrollToSourceHandler.setShouldAutoScroll(true);
    }

    @Override
    public void setActionActive(String name, boolean state) {
        StructureViewFactoryEx.getInstanceEx(this.myProject).setActiveAction(name, state);
        this.rebuild();
        TreeUtil.expand((JTree)this.getTree(), (int)2);
    }

    protected void rebuild() {
        this.storeState();
        ++ourSettingsModificationCount;
        ((SmartTreeStructure)this.myAbstractTreeBuilder.getTreeStructure()).rebuildTree();
        this.myAbstractTreeBuilder.updateFromRoot();
        this.restoreState();
    }

    @Override
    public boolean isActionActive(String name) {
        return !this.myProject.isDisposed() && StructureViewFactoryEx.getInstanceEx(this.myProject).isActionActive(name);
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myAbstractTreeBuilder.getTreeStructure();
    }

    public JTree getTree() {
        return this.myAbstractTreeBuilder == null ? null : this.myAbstractTreeBuilder.getTree();
    }

    public Object getData(String dataId) {
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            TreePath path = this.getSelectedUniquePath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof AbstractTreeNode)) {
                return null;
            }
            AbstractTreeNode descriptor = (AbstractTreeNode)userObject;
            Object element = descriptor.getValue();
            if (element instanceof StructureViewTreeElement) {
                element = ((StructureViewTreeElement)element).getValue();
            }
            if (!(element instanceof PsiElement)) {
                return null;
            }
            if (!((PsiElement)element).isValid()) {
                return null;
            }
            return element;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return StructureViewComponent.convertToPsiElementsArray(this.getSelectedElements());
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditor;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            Object[] selectedElements = this.getSelectedTreeElements();
            if (selectedElements == null || selectedElements.length == 0) {
                return null;
            }
            if (selectedElements[0] instanceof Navigatable) {
                return selectedElements[0];
            }
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        return null;
    }

    private static PsiElement[] convertToPsiElementsArray(Object[] selectedElements) {
        if (selectedElements == null) {
            return null;
        }
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (Object selectedElement : selectedElements) {
            if (!(selectedElement instanceof PsiElement) || !((PsiElement)selectedElement).isValid()) continue;
            psiElements.add((PsiElement)selectedElement);
        }
        return psiElements.toArray(new PsiElement[psiElements.size()]);
    }

    private TreePath getSelectedUniquePath() {
        JTree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        TreePath[] paths = tree.getSelectionPaths();
        return paths == null || paths.length != 1 ? null : paths[0];
    }

    public StructureViewModel getTreeModel() {
        return this.myTreeModel;
    }

    public boolean navigateToSelectedElement(boolean requestFocus) {
        return this.select(this.myTreeModel.getCurrentEditorElement(), requestFocus);
    }

    public void doUpdate() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myAbstractTreeBuilder.addRootToUpdate();
    }

    private static boolean isValid(Object treeElement) {
        StructureViewTreeElementWrapper wrapper;
        if (treeElement instanceof StructureViewTreeElementWrapper && (wrapper = (StructureViewTreeElementWrapper)((Object)treeElement)).getValue() instanceof PsiTreeElementBase) {
            PsiTreeElementBase psiNode = (PsiTreeElementBase)wrapper.getValue();
            return psiNode.isValid();
        }
        return true;
    }

    public String getHelpID() {
        return ourHelpID;
    }

    public Dimension getCurrentSize() {
        return this.myTree.getSize();
    }

    public void setReferenceSizeWhileInitializing(Dimension size) {
        this._setRefSize(size);
        if (size != null) {
            this.myAbstractTreeBuilder.getReady(this).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    StructureViewComponent.this._setRefSize(null);
                }
            });
        }
    }

    private void _setRefSize(Dimension size) {
        this.myTree.setPreferredSize(size);
        this.myTree.setMinimumSize(size);
        this.myTree.setMaximumSize(size);
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    static class StructureViewTreeElementWrapper
    extends TreeElementWrapper
    implements NodeDescriptorProvidingKey {
        private long childrenStamp = -1L;
        private long modificationCountForChildren = StructureViewComponent.access$1100();

        public StructureViewTreeElementWrapper(Project project, TreeElement value, TreeModel treeModel) {
            super(project, value, treeModel);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Object getKey() {
            Object object;
            StructureViewTreeElement element = (StructureViewTreeElement)this.getValue();
            if (element instanceof NodeDescriptorProvidingKey) {
                object = ((NodeDescriptorProvidingKey)element).getKey();
                if (object == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureViewComponent$StructureViewTreeElementWrapper.getKey must not return null");
                return object;
            }
            Object value = element.getValue();
            object = value == null ? this : value;
            if (object != null) return object;
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureViewComponent$StructureViewTreeElementWrapper.getKey must not return null");
        }

        @Override
        @NotNull
        public Collection<AbstractTreeNode> getChildren() {
            long currentStamp;
            Object o;
            if ((long)ourSettingsModificationCount != this.modificationCountForChildren) {
                this.resetChildren();
                this.modificationCountForChildren = ourSettingsModificationCount;
            }
            if ((o = StructureViewTreeElementWrapper.unwrapValue(this.getValue())) instanceof PsiElement && ((PsiElement)o).getNode() instanceof CompositeElement && this.childrenStamp != (currentStamp = (long)((CompositeElement)((PsiElement)o).getNode()).getModificationCount()) || o instanceof ModificationTracker && this.childrenStamp != (currentStamp = ((ModificationTracker)o).getModificationCount())) {
                this.resetChildren();
                this.childrenStamp = currentStamp;
            }
            Collection<AbstractTreeNode> collection = super.getChildren();
            if (collection == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureViewComponent$StructureViewTreeElementWrapper.getChildren must not return null");
            }
            return collection;
        }

        public boolean isAlwaysShowPlus() {
            if (this.getElementInfoProvider() != null) {
                return this.getElementInfoProvider().isAlwaysShowsPlus((StructureViewTreeElement)this.getValue());
            }
            return true;
        }

        public boolean isAlwaysLeaf() {
            if (this.getElementInfoProvider() != null) {
                return this.getElementInfoProvider().isAlwaysLeaf((StructureViewTreeElement)this.getValue());
            }
            return false;
        }

        private StructureViewModel.ElementInfoProvider getElementInfoProvider() {
            StructureViewModel model;
            if (this.myTreeModel instanceof StructureViewModel.ElementInfoProvider) {
                return (StructureViewModel.ElementInfoProvider)this.myTreeModel;
            }
            if (this.myTreeModel instanceof TreeModelWrapper && (model = ((TreeModelWrapper)this.myTreeModel).getModel()) instanceof StructureViewModel.ElementInfoProvider) {
                return (StructureViewModel.ElementInfoProvider)model;
            }
            return null;
        }

        @Override
        protected TreeElementWrapper createChildNode(TreeElement child) {
            return new StructureViewTreeElementWrapper(this.myProject, child, this.myTreeModel);
        }

        @Override
        protected GroupWrapper createGroupWrapper(Project project, Group group, TreeModel treeModel) {
            return new StructureViewGroup(project, group, treeModel);
        }

        public boolean equals(Object o) {
            if (o instanceof StructureViewTreeElementWrapper) {
                return Comparing.equal((Object)StructureViewTreeElementWrapper.unwrapValue(this.getValue()), (Object)StructureViewTreeElementWrapper.unwrapValue(((StructureViewTreeElementWrapper)((Object)o)).getValue()));
            }
            if (o instanceof StructureViewTreeElement) {
                return Comparing.equal((Object)StructureViewTreeElementWrapper.unwrapValue(this.getValue()), (Object)((StructureViewTreeElement)o).getValue());
            }
            return false;
        }

        private static Object unwrapValue(Object o) {
            if (o instanceof StructureViewTreeElement) {
                return ((StructureViewTreeElement)o).getValue();
            }
            return o;
        }

        public int hashCode() {
            Object o = StructureViewTreeElementWrapper.unwrapValue(this.getValue());
            return o != null ? o.hashCode() : 0;
        }

        private class StructureViewGroup
        extends GroupWrapper {
            public StructureViewGroup(Project project, Group group, TreeModel treeModel) {
                super(project, group, treeModel);
            }

            @Override
            protected TreeElementWrapper createChildNode(TreeElement child) {
                return new StructureViewTreeElementWrapper(this.getProject(), child, this.myTreeModel);
            }

            @Override
            protected GroupWrapper createGroupWrapper(Project project, Group group, TreeModel treeModel) {
                return new StructureViewGroup(project, group, treeModel);
            }

            public boolean isAlwaysShowPlus() {
                return true;
            }
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private FileEditorPositionListener myFileEditorPositionListener;

        private MyAutoScrollFromSourceHandler(Project project, Disposable parentDisposable) {
            super(project, parentDisposable);
        }

        public void install() {
            this.addEditorCaretListener();
        }

        public void dispose() {
            StructureViewComponent.this.myTreeModel.removeEditorPositionListener(this.myFileEditorPositionListener);
        }

        private void addEditorCaretListener() {
            this.myFileEditorPositionListener = new FileEditorPositionListener(){

                public void onCurrentElementChanged() {
                    StructureViewComponent.this.scrollToSelectedElement();
                }
            };
            StructureViewComponent.this.myTreeModel.addEditorPositionListener(this.myFileEditorPositionListener);
        }

        protected boolean isAutoScrollMode() {
            StructureViewFactoryImpl structureViewFactory = (StructureViewFactoryImpl)StructureViewFactoryEx.getInstance((Project)this.myProject);
            return structureViewFactory.getState().AUTOSCROLL_FROM_SOURCE;
        }

        protected void setAutoScrollMode(boolean state) {
            StructureViewFactoryImpl structureViewFactory = (StructureViewFactoryImpl)StructureViewFactoryEx.getInstance((Project)this.myProject);
            structureViewFactory.getState().AUTOSCROLL_FROM_SOURCE = state;
            FileEditor[] selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors();
            if (selectedEditors.length > 0 && state) {
                StructureViewComponent.this.scrollToSelectedElement();
            }
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        private boolean myShouldAutoScroll = true;

        private MyAutoScrollToSourceHandler() {
        }

        public void setShouldAutoScroll(boolean shouldAutoScroll) {
            this.myShouldAutoScroll = shouldAutoScroll;
        }

        protected boolean isAutoScrollMode() {
            return this.myShouldAutoScroll && ((StructureViewFactoryImpl)StructureViewFactoryEx.getInstance((Project)((StructureViewComponent)StructureViewComponent.this).myProject)).getState().AUTOSCROLL_MODE;
        }

        protected void setAutoScrollMode(boolean state) {
            ((StructureViewFactoryImpl)StructureViewFactoryEx.getInstance((Project)((StructureViewComponent)StructureViewComponent.this).myProject)).getState().AUTOSCROLL_MODE = state;
        }

        protected void scrollToSource(Component tree) {
            if (StructureViewComponent.this.myAbstractTreeBuilder == null) {
                return;
            }
            StructureViewComponent.this.myAutoscrollFeedback = true;
            Navigatable editSourceDescriptor = (Navigatable)LangDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext((Component)StructureViewComponent.this.getTree()));
            if (StructureViewComponent.this.myFileEditor != null && editSourceDescriptor != null && editSourceDescriptor.canNavigateToSource()) {
                editSourceDescriptor.navigate(false);
            }
        }
    }
}

