/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProjectTreeBuilder
extends AbstractTreeBuilder {
    protected final Project myProject;

    public BaseProjectTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator) {
        this.init(tree, treeModel, treeStructure, comparator, true);
        this.myProject = project;
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        final AsyncResult result = new AsyncResult();
        if (element instanceof AbstractTreeNode) {
            PsiFile psiFile;
            AbstractTreeNode node = (AbstractTreeNode)element;
            final Object value = node.getValue();
            VirtualFile vFile = null;
            if (value instanceof PsiFileSystemItem) {
                vFile = ((PsiFileSystemItem)value).getVirtualFile();
            } else if (value instanceof PsiElement && (psiFile = ((PsiElement)value).getContainingFile()) != null) {
                vFile = psiFile.getVirtualFile();
            }
            final ActionCallback cb = new ActionCallback();
            final VirtualFile finalVFile = vFile;
            final FocusRequestor focusRequestor = IdeFocusManager.getInstance((Project)this.myProject).getFurtherRequestor();
            this.batch(new Progressive(){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/BaseProjectTreeBuilder$1.run must not be null");
                    }
                    final Ref target = new Ref();
                    BaseProjectTreeBuilder.this._select(value, finalVFile, false, (Condition<AbstractTreeNode>)Conditions.alwaysTrue(), cb, indicator, (Ref<Object>)target, focusRequestor, false);
                    cb.doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            result.setDone(target.get());
                        }
                    }).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            result.setRejected();
                        }
                    });
                }
            });
        } else {
            result.setRejected();
        }
        return result;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((AbstractTreeNode)nodeDescriptor).isAlwaysShowPlus();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null || ((AbstractTreeNode)nodeDescriptor).isAlwaysExpand();
    }

    protected final void expandNodeChildren(DefaultMutableTreeNode node) {
        Object element = ((NodeDescriptor)node.getUserObject()).getElement();
        VirtualFile virtualFile = BaseProjectTreeBuilder.getFileToRefresh(element);
        super.expandNodeChildren(node);
        if (virtualFile != null) {
            virtualFile.refresh(true, false);
        }
    }

    private static VirtualFile getFileToRefresh(Object element) {
        return element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : (element instanceof PsiFile ? ((PsiFile)element).getVirtualFile() : null);
    }

    private List<AbstractTreeNode> getOrBuildChildren(AbstractTreeNode parent) {
        this.buildNodeForElement(parent);
        DefaultMutableTreeNode node = this.getNodeForElement(parent);
        if (node == null) {
            return new ArrayList<AbstractTreeNode>();
        }
        this.getTree().expandPath(new TreePath(node.getPath()));
        return this.collectChildren(node);
    }

    private List<AbstractTreeNode> collectChildren(DefaultMutableTreeNode node) {
        int childCount = node.getChildCount();
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            ProjectViewNode treeNode;
            TreeNode childAt = node.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)childAt;
            if (defaultMutableTreeNode.getUserObject() instanceof AbstractTreeNode) {
                treeNode = (ProjectViewNode)defaultMutableTreeNode.getUserObject();
                result.add((AbstractTreeNode)treeNode);
                continue;
            }
            if (!(defaultMutableTreeNode.getUserObject() instanceof FavoritesTreeNodeDescriptor)) continue;
            treeNode = ((FavoritesTreeNodeDescriptor)((Object)defaultMutableTreeNode.getUserObject())).getElement();
            result.add((AbstractTreeNode)treeNode);
        }
        return result;
    }

    public ActionCallback select(Object element, VirtualFile file, boolean requestFocus) {
        return this._select(element, file, requestFocus, (Condition<AbstractTreeNode>)Conditions.alwaysTrue());
    }

    public ActionCallback selectInWidth(Object element, boolean requestFocus, Condition<AbstractTreeNode> nonStopCondition) {
        return this._select(element, null, requestFocus, nonStopCondition);
    }

    private ActionCallback _select(final Object element, final VirtualFile file, final boolean requestFocus, final Condition<AbstractTreeNode> nonStopCondition) {
        final ActionCallback result = new ActionCallback();
        final FocusRequestor requestor = IdeFocusManager.getInstance((Project)this.myProject).getFurtherRequestor();
        this.cancelUpdate().doWhenDone(new Runnable(){

            @Override
            public void run() {
                BaseProjectTreeBuilder.this.batch(new Progressive(){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/BaseProjectTreeBuilder$2$1.run must not be null");
                        }
                        BaseProjectTreeBuilder.this._select(element, file, requestFocus, (Condition<AbstractTreeNode>)nonStopCondition, result, indicator, (Ref<Object>)null, requestor, false);
                    }
                });
            }
        });
        return result;
    }

    private void _select(Object element, final VirtualFile file, final boolean requestFocus, final Condition<AbstractTreeNode> nonStopCondition, final ActionCallback result, final ProgressIndicator indicator, final @Nullable Ref<Object> virtualSelectTarget, final FocusRequestor focusRequestor, final boolean isSecondAttempt) {
        AbstractTreeNode alreadySelected = this.alreadySelectedNode(element);
        final Runnable onDone = new Runnable(){

            @Override
            public void run() {
                if (requestFocus && virtualSelectTarget == null) {
                    focusRequestor.requestFocus((Component)BaseProjectTreeBuilder.this.getTree(), true);
                }
                result.setDone();
            }
        };
        Condition<AbstractTreeNode> condition = new Condition<AbstractTreeNode>(){

            public boolean value(AbstractTreeNode abstractTreeNode) {
                if (result.isProcessed()) {
                    return false;
                }
                return nonStopCondition.value((Object)abstractTreeNode);
            }
        };
        if (alreadySelected == null) {
            this.expandPathTo(file, (AbstractTreeNode)this.getTreeStructure().getRootElement(), element, condition, indicator, virtualSelectTarget).doWhenDone((AsyncResult.Handler)new AsyncResult.Handler<AbstractTreeNode>(){

                public void run(AbstractTreeNode node) {
                    if (virtualSelectTarget == null) {
                        BaseProjectTreeBuilder.this.select(node, onDone);
                    } else if (onDone != null) {
                        onDone.run();
                    }
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    if (isSecondAttempt) {
                        result.setRejected();
                    } else {
                        BaseProjectTreeBuilder.this._select(file, file, requestFocus, (Condition<AbstractTreeNode>)nonStopCondition, result, indicator, (Ref<Object>)virtualSelectTarget, focusRequestor, true);
                    }
                }
            });
        } else if (virtualSelectTarget == null) {
            this.select(alreadySelected, onDone);
        } else if (onDone != null) {
            onDone.run();
        }
    }

    private AbstractTreeNode alreadySelectedNode(Object element) {
        TreePath[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        for (TreePath selectionPath : selectionPaths) {
            Object selected = selectionPath.getLastPathComponent();
            if (!BaseProjectTreeBuilder.elementIsEqualTo(selected, element)) continue;
            return (AbstractTreeNode)((DefaultMutableTreeNode)selected).getUserObject();
        }
        return null;
    }

    private static boolean elementIsEqualTo(Object node, Object element) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)userObject;
            return projectViewNode.canRepresent(element);
        }
        return false;
    }

    private AsyncResult<AbstractTreeNode> expandPathTo(final VirtualFile file, final AbstractTreeNode root, final Object element, final Condition<AbstractTreeNode> nonStopCondition, final ProgressIndicator indicator, final @Nullable Ref<Object> target) {
        final AsyncResult async = new AsyncResult();
        if (root.canRepresent(element)) {
            if (target == null) {
                this.expand(root, new Runnable(){

                    @Override
                    public void run() {
                        async.setDone((Object)root);
                    }
                });
            } else {
                target.set((Object)root);
                async.setDone((Object)root);
            }
            return async;
        }
        if (root instanceof ProjectViewNode && file != null && !((ProjectViewNode)root).contains(file)) {
            async.setRejected();
            return async;
        }
        if (target == null) {
            this.expand(root, new Runnable(){

                @Override
                public void run() {
                    indicator.checkCanceled();
                    DefaultMutableTreeNode rootNode = BaseProjectTreeBuilder.this.getNodeForElement(root);
                    if (rootNode != null) {
                        List kids = BaseProjectTreeBuilder.this.collectChildren(rootNode);
                        BaseProjectTreeBuilder.this.expandChild(kids, 0, (Condition<AbstractTreeNode>)nonStopCondition, file, element, (AsyncResult<AbstractTreeNode>)async, indicator, (Ref<Object>)target);
                    } else {
                        async.setRejected();
                    }
                }
            });
        } else if (indicator.isCanceled()) {
            async.setRejected();
        } else {
            DefaultMutableTreeNode rootNode = this.getNodeForElement(root);
            final ArrayList<AbstractTreeNode> kids = new ArrayList<AbstractTreeNode>();
            if (rootNode != null && this.getTree().isExpanded(new TreePath(rootNode.getPath()))) {
                kids.addAll(this.collectChildren(rootNode));
            } else {
                List<Object> list = Arrays.asList(this.getTreeStructure().getChildElements((Object)root));
                for (Object each : list) {
                    kids.add((AbstractTreeNode)each);
                }
            }
            this.yield(new Runnable(){

                @Override
                public void run() {
                    BaseProjectTreeBuilder.this.expandChild(kids, 0, (Condition<AbstractTreeNode>)nonStopCondition, file, element, (AsyncResult<AbstractTreeNode>)async, indicator, (Ref<Object>)target);
                }
            });
        }
        return async;
    }

    private void expandChild(final List<AbstractTreeNode> kids, final int i, final Condition<AbstractTreeNode> nonStopCondition, final VirtualFile file, final Object element, final AsyncResult<AbstractTreeNode> async, final ProgressIndicator indicator, final Ref<Object> virtualSelectTarget) {
        if (i >= kids.size()) {
            async.setRejected();
            return;
        }
        final AbstractTreeNode eachKid = kids.get(i);
        final boolean[] nodeWasCollapsed = new boolean[]{true};
        DefaultMutableTreeNode nodeForElement = this.getNodeForElement(eachKid);
        if (nodeForElement != null) {
            nodeWasCollapsed[0] = this.getTree().isCollapsed(new TreePath(nodeForElement.getPath()));
        }
        if (nonStopCondition.value((Object)eachKid)) {
            this.expandPathTo(file, eachKid, element, nonStopCondition, indicator, virtualSelectTarget).doWhenDone((AsyncResult.Handler)new AsyncResult.Handler<AbstractTreeNode>(){

                public void run(AbstractTreeNode abstractTreeNode) {
                    indicator.checkCanceled();
                    async.setDone((Object)abstractTreeNode);
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    indicator.checkCanceled();
                    if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                        BaseProjectTreeBuilder.this.collapseChildren(eachKid, null);
                    }
                    BaseProjectTreeBuilder.this.expandChild(kids, i + 1, (Condition<AbstractTreeNode>)nonStopCondition, file, element, (AsyncResult<AbstractTreeNode>)async, indicator, (Ref<Object>)virtualSelectTarget);
                }
            });
        } else {
            async.setRejected();
        }
    }

    protected boolean validateNode(Object child) {
        if (child instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)child;
            return projectViewNode.validate();
        }
        return true;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/BaseProjectTreeBuilder.createProgressIndicator must not return null");
        }
        return statusBarProgress;
    }
}

