/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        VirtualFile[] files = SynchronizeCurrentFileAction.getFiles(e);
        if (SynchronizeCurrentFileAction.getProject(e) == null || files == null || files.length == 0) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String message = SynchronizeCurrentFileAction.getMessage(files);
        e.getPresentation().setEnabled(true);
        e.getPresentation().setText(message);
    }

    private static String getMessage(VirtualFile[] files) {
        if (files.length == 1) {
            return IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{files[0].getName().replace("_", "__").replace("&", "&&")});
        }
        return IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = SynchronizeCurrentFileAction.getProject(e);
        final VirtualFile[] files = SynchronizeCurrentFileAction.getFiles(e);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile f : files) {
                    f.refresh(false, true);
                }
            }
        });
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile f : files) {
            if (f.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(f);
                continue;
            }
            dirtyScopeManager.fileDirty(f);
        }
        String message = IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(files)});
        WindowManager.getInstance().getStatusBar(project).setInfo(message);
    }

    private static Project getProject(AnActionEvent e) {
        return (Project)e.getData(PlatformDataKeys.PROJECT);
    }

    private static VirtualFile[] getFiles(AnActionEvent e) {
        return (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
    }
}

