/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateFileAction
extends CreateElementActionBase
implements DumbAware {
    public CreateFileAction() {
        super(IdeBundle.message((String)"action.create.new.file", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.file", (Object[])new Object[0]), IconLoader.getIcon((String)"/fileTypes/text.png"));
    }

    public CreateFileAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected boolean isDumbAware() {
        return CreateFileAction.class.equals(((Object)((Object)this)).getClass());
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        MyValidator validator = new MyValidator(project, directory);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.file.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateFileAction.invokeDialog must not return null");
        }
        return psiElementArray;
    }

    protected void checkBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        directory.checkCreateFile(newName);
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray = new PsiElement[]{directory.createFile(newName)};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateFileAction.create must not return null");
        }
        return psiElementArray;
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return IdeBundle.message((String)"progress.creating.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), File.separator, newName});
    }

    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    protected String getCommandName() {
        return IdeBundle.message((String)"command.create.file", (Object[])new Object[0]);
    }

    protected class MyValidator
    extends CreateElementActionBase.MyInputValidator {
        public boolean checkInput(String inputString) {
            return true;
        }

        public boolean canClose(String inputString) {
            if (inputString.length() == 0) {
                return super.canClose(inputString);
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(inputString);
            return type != null && super.canClose(inputString);
        }

        public MyValidator(Project project, PsiDirectory directory) {
            super((CreateElementActionBase)CreateFileAction.this, project, directory);
        }
    }
}

