/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class ChangeRevertionVisitor
extends ChangeVisitor {
    private final IdeaGateway myGateway;
    private final Set<DelayedApply> myDelayedApplies = new HashSet();

    public ChangeRevertionVisitor(IdeaGateway gw) {
        this.myGateway = gw;
    }

    @Override
    public void visit(CreateEntryChange c) throws IOException, ChangeVisitor.StopVisitingException {
        Entry e;
        VirtualFile f;
        if (this.shouldRevert(c) && (f = this.myGateway.findVirtualFile((e = this.getAffectedEntry(c)).getPath())) != null) {
            this.unregisterDelayedApplies(f);
            f.delete((Object)this);
        }
        c.revertOn(this.myRoot);
        this.checkShouldStop(c);
    }

    @Override
    public void visit(ContentChange c) throws IOException, ChangeVisitor.StopVisitingException {
        c.revertOn(this.myRoot);
        if (this.shouldRevert(c)) {
            Entry e = this.getAffectedEntry(c);
            VirtualFile f = this.myGateway.findVirtualFile(e.getPath());
            this.registerDelayedContentApply(f, e);
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(RenameChange c) throws IOException, ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c)) {
            Entry e = this.getAffectedEntry(c);
            VirtualFile f = this.myGateway.findOrCreateFileSafely(e.getPath(), e.isDirectory());
            c.revertOn(this.myRoot);
            String newName = this.getName(e);
            VirtualFile existing = f.getParent().findChild(newName);
            if (existing != null && existing != f) {
                existing.delete((Object)this);
            }
            f.rename((Object)this, newName);
        } else {
            c.revertOn(this.myRoot);
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(ROStatusChange c) throws IOException, ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c)) {
            Entry e = this.getAffectedEntry(c);
            VirtualFile f = this.myGateway.findOrCreateFileSafely(e.getPath(), e.isDirectory());
            c.revertOn(this.myRoot);
            this.registerDelayedROStatusApply(f, e);
        } else {
            c.revertOn(this.myRoot);
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(MoveChange c) throws IOException, ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c)) {
            Entry e = this.getAffectedEntry(c, 1);
            VirtualFile f = this.myGateway.findOrCreateFileSafely(e.getPath(), e.isDirectory());
            c.revertOn(this.myRoot);
            String parentPath = this.getParentPath(this.getAffectedEntry(c));
            VirtualFile parent = this.myGateway.findOrCreateFileSafely(parentPath, true);
            VirtualFile existing = parent.findChild(e.getName());
            if (existing != null) {
                existing.delete((Object)this);
            }
            f.move((Object)this, parent);
        } else {
            c.revertOn(this.myRoot);
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(DeleteChange c) throws IOException, ChangeVisitor.StopVisitingException {
        c.revertOn(this.myRoot);
        if (this.shouldRevert(c)) {
            Entry e = this.getAffectedEntry(c);
            this.revertDeletion(e);
        }
        this.checkShouldStop(c);
    }

    protected boolean shouldRevert(Change c) {
        return true;
    }

    protected void checkShouldStop(Change c) throws ChangeVisitor.StopVisitingException {
    }

    private void revertDeletion(Entry e) throws IOException {
        VirtualFile f = this.myGateway.findOrCreateFileSafely(e, e.getPath(), e.isDirectory());
        if (e.isDirectory()) {
            for (Entry child : e.getChildren()) {
                this.revertDeletion(child);
            }
        } else {
            this.registerDelayedContentApply(f, e);
            this.registerDelayedROStatusApply(f, e);
        }
    }

    private void registerDelayedContentApply(VirtualFile f, Entry e) {
        this.registerDelayedApply(new DelayedContentApply(f, e));
    }

    private void registerDelayedROStatusApply(VirtualFile f, Entry e) {
        this.registerDelayedApply(new DelayedROStatusApply(f, e));
    }

    private void registerDelayedApply(DelayedApply a) {
        this.myDelayedApplies.remove(a);
        this.myDelayedApplies.add(a);
    }

    private void unregisterDelayedApplies(VirtualFile fileOrDir) {
        ArrayList<DelayedApply> toRemove = new ArrayList<DelayedApply>();
        for (DelayedApply a : this.myDelayedApplies) {
            if (!VfsUtil.isAncestor((VirtualFile)fileOrDir, (VirtualFile)a.getFile(), (boolean)false)) continue;
            toRemove.add(a);
        }
        for (DelayedApply a : toRemove) {
            this.myDelayedApplies.remove(a);
        }
    }

    @Override
    public void finished() throws IOException {
        for (DelayedApply a : this.myDelayedApplies) {
            a.apply();
        }
    }

    protected Entry getAffectedEntry(StructuralChange c) {
        return this.getAffectedEntry(c, 0);
    }

    private Entry getAffectedEntry(StructuralChange c, int i) {
        return this.myRoot.getEntry(c.getAffectedIdPaths()[i]);
    }

    private String getParentPath(Entry e) {
        return Paths.getParentOf(e.getPath());
    }

    private String getName(Entry e) {
        return Paths.getNameOf(e.getPath());
    }

    private static class DelayedROStatusApply
    extends DelayedApply {
        private final boolean isReadOnly;

        private DelayedROStatusApply(VirtualFile f, Entry e) {
            super(f);
            this.isReadOnly = e.isReadOnly();
        }

        @Override
        public void apply() throws IOException {
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)this.isReadOnly);
        }
    }

    private static class DelayedContentApply
    extends DelayedApply {
        private final Content myContent;
        private final long myTimestamp;

        public DelayedContentApply(VirtualFile f, Entry e) {
            super(f);
            this.myContent = e.getContent();
            this.myTimestamp = e.getTimestamp();
        }

        @Override
        public void apply() throws IOException {
            if (!this.myContent.isAvailable()) {
                return;
            }
            boolean isReadOnly = !this.myFile.isWritable();
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)false);
            this.myFile.setBinaryContent(this.myContent.getBytes(), -1L, this.myTimestamp);
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)isReadOnly);
        }
    }

    private static abstract class DelayedApply {
        protected VirtualFile myFile;

        protected DelayedApply(VirtualFile f) {
            this.myFile = f;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public abstract void apply() throws IOException;

        public boolean equals(Object o) {
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.myFile.equals(((DelayedApply)o).myFile);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 32 * this.myFile.hashCode();
        }
    }
}

