/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.testframework.ExternalOutput;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTestsOutputConsoleView
implements ConsoleView,
ObservableConsoleView {
    private ConsoleView myConsole;
    private TestsOutputConsolePrinter myPrinter;
    protected TestConsoleProperties myProperties;
    protected TestResultsPanel myTestResultsPanel;

    public BaseTestsOutputConsoleView(TestConsoleProperties properties) {
        this.myProperties = properties;
        this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(properties.getProject(), this.myProperties.getScope()).getConsole();
        this.myPrinter = new TestsOutputConsolePrinter(this.myConsole, properties);
        this.myProperties.setConsole(this);
        Disposer.register((Disposable)this, (Disposable)this.myProperties);
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    public void initUI() {
        this.myTestResultsPanel = this.createTestResultsPanel();
        this.myTestResultsPanel.initUI();
        Disposer.register((Disposable)this, (Disposable)this.myTestResultsPanel);
    }

    protected abstract TestResultsPanel createTestResultsPanel();

    public void print(String s, ConsoleViewContentType contentType) {
        this.printNew(new ExternalOutput(s, contentType));
    }

    public void clear() {
        this.myConsole.clear();
    }

    public void scrollTo(int offset) {
        this.myConsole.scrollTo(offset);
    }

    public void setOutputPaused(boolean value) {
        if (this.myPrinter != null) {
            this.myPrinter.pause(value);
        }
    }

    public boolean isOutputPaused() {
        return this.myPrinter == null ? true : this.myPrinter.isPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myConsole.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
        this.myConsole.performWhenNoDeferredOutput(runnable);
    }

    public void setHelpId(String helpId) {
        this.myConsole.setHelpId(helpId);
    }

    public void addMessageFilter(Filter filter) {
        this.myConsole.addMessageFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.printNew(new HyperLink(hyperlinkText, info));
    }

    public int getContentSize() {
        return this.myConsole.getContentSize();
    }

    public boolean canPause() {
        return this.myPrinter != null && this.myPrinter.canPause() && this.myConsole.canPause();
    }

    public JComponent getComponent() {
        return this.myTestResultsPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myConsole.getPreferredFocusableComponent();
    }

    public void dispose() {
        this.myPrinter = null;
        this.myProperties = null;
        this.myConsole = null;
    }

    public void addChangeListener(ObservableConsoleView.ChangeListener listener, Disposable parent) {
        if (!(this.myConsole instanceof ObservableConsoleView)) {
            throw new UnsupportedOperationException(this.myConsole.getClass().getName());
        }
        ((ObservableConsoleView)this.myConsole).addChangeListener(listener, parent);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView.createConsoleActions must not return null");
        }
        return AnAction.EMPTY_ARRAY;
    }

    protected ConsoleView getConsole() {
        return this.myConsole;
    }

    public TestsOutputConsolePrinter getPrinter() {
        return this.myPrinter;
    }

    private void printNew(Printable printable) {
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }
}

