/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.stacktrace;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class DiffHyperlink
implements Printable {
    private static final String NEW_LINE = "\n";
    protected final String myExpected;
    protected final String myActual;
    protected final String myFilePath;
    private final HyperlinkInfo myDiffHyperlink = new HyperlinkInfo(){

        public void navigate(Project project) {
            DiffHyperlink.this.openDiff(project);
        }
    };

    public DiffHyperlink(String expected, String actual, String filePath) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = filePath == null ? null : filePath.replace(File.separatorChar, '/');
    }

    public void openDiff(Project project) {
        SimpleContent expectedContent;
        VirtualFile vFile;
        String expectedTitle = ExecutionBundle.message((String)"diff.content.expected.title", (Object[])new Object[0]);
        if (this.myFilePath != null && (vFile = LocalFileSystem.getInstance().findFileByPath(this.myFilePath)) != null) {
            expectedContent = DiffContent.fromFile((Project)project, (VirtualFile)vFile);
            expectedTitle = expectedTitle + " (" + vFile.getPresentableUrl() + ")";
        } else {
            expectedContent = new SimpleContent(this.myExpected);
        }
        SimpleDiffRequest diffData = new SimpleDiffRequest(project, this.getTitle());
        diffData.setContents((DiffContent)expectedContent, (DiffContent)new SimpleContent(this.myActual));
        diffData.setContentTitles(expectedTitle, ExecutionBundle.message((String)"diff.content.actual.title", (Object[])new Object[0]));
        diffData.addHint(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG);
        diffData.addHint(DiffTool.HINT_DO_NOT_IGNORE_WHITESPACES);
        diffData.setGroupKey("#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
        DiffManager.getInstance().getIdeaDiffTool().show((DiffRequest)diffData);
    }

    protected String getTitle() {
        return ExecutionBundle.message((String)"strings.equal.failed.dialog.title", (Object[])new Object[0]);
    }

    public String getLeft() {
        return this.myExpected;
    }

    public String getRight() {
        return this.myActual;
    }

    @Override
    public void printOn(Printer printer) {
        if (DiffHyperlink.hasMoreThanOneLine(this.myActual) || DiffHyperlink.hasMoreThanOneLine(this.myExpected)) {
            printer.print(" ", ConsoleViewContentType.ERROR_OUTPUT);
            printer.printHyperlink(ExecutionBundle.message((String)"junit.click.to.see.diff.link", (Object[])new Object[0]), this.myDiffHyperlink);
            printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
        } else {
            printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
            printer.print(ExecutionBundle.message((String)"diff.content.expected.for.file.title", (Object[])new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            printer.print(this.myExpected + NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
            printer.print(ExecutionBundle.message((String)"junit.actual.text.label", (Object[])new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            printer.print(this.myActual + NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    private static boolean hasMoreThanOneLine(String string) {
        return string.indexOf(10) != -1 || string.indexOf(13) != -1;
    }
}

