/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.statistics.BaseColumn;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColoredRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnTest
extends BaseColumn
implements Comparator<SMTestProxy> {
    public ColumnTest() {
        super(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.test.title", new Object[0]));
    }

    @NotNull
    public String valueOf(SMTestProxy testProxy) {
        String string = testProxy.getPresentableName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/ui/statistics/ColumnTest.valueOf must not return null");
        }
        return string;
    }

    @Nullable
    public Comparator<SMTestProxy> getComparator() {
        return this;
    }

    @Override
    public int compare(SMTestProxy proxy1, SMTestProxy proxy2) {
        return proxy1.getName().compareTo(proxy2.getName());
    }

    public TableCellRenderer getRenderer(SMTestProxy proxy) {
        return new TestsCellRenderer(proxy);
    }

    public static class TestsCellRenderer
    extends ColoredTableCellRenderer
    implements ColoredRenderer {
        @NonNls
        private static final String TOTAL_TITLE = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.test.total.title", new Object[0]);
        @NonNls
        private static final String PARENT_TITLE = "..";
        private final SMTestProxy myProxy;

        public TestsCellRenderer(SMTestProxy proxy) {
            this.myProxy = proxy;
        }

        @Override
        public void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            assert (value != null);
            String title = value.toString();
            if (this.myProxy.isSuite() && TestsCellRenderer.isFirstLine(row)) {
                if (this.myProxy.getParent() == null) {
                    this.append(TOTAL_TITLE, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(PARENT_TITLE, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    this.append(" (" + this.myProxy.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                return;
            }
            this.append(title, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        public static boolean isFirstLine(int row) {
            return row == 0;
        }
    }
}

