/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport.itn;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.bean.ExceptionBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.util.SystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class ITNProxy {
    @NonNls
    public static final String ENCODE = "UTF8";
    public static final String POST_DELIMETER = "&";
    @NonNls
    public static final String NEW_THREAD_URL = "http://www.intellij.net/trackerRpc/idea/createScr";
    public static final String THREAD_SUBJECT = "[{0}]";
    @NonNls
    private static final String HTTP_CONTENT_LENGTH = "Content-Length";
    @NonNls
    private static final String HTTP_CONTENT_TYPE = "Content-Type";
    @NonNls
    private static final String HTTP_WWW_FORM = "application/x-www-form-urlencoded";
    @NonNls
    private static final String HTTP_POST = "POST";
    public static final String SUN = "Sun";
    public static final String JDK_1_2_2 = "1.2.2";
    public static final String JDK_1_3_0 = "1.3.0";
    public static final String JDK_1_3_1 = "1.3.1";
    public static final String JDK_1_3_1_01 = "1.3.1_01";
    public static final String JDK_1_4_0 = "1.4.0";
    public static final String JDK_1_4_0_01 = "1.4.0_01";
    public static final String JDK_1_4_0_02 = "1.4.0_02";
    public static final String JDK_1_4_1 = "1.4.1";
    public static final String JDK_1_4_2 = "1.4.2";
    @NonNls
    public static final String WINDOWS_XP = "Windows XP";
    @NonNls
    public static final String WINDOWS_2000 = "Windows 2000";
    @NonNls
    public static final String WINDOWS_NT = "Windows NT";
    @NonNls
    public static final String WINDOWS_95 = "Windows 95";
    @NonNls
    public static final String WINDOWS_98 = "Windows 98";
    @NonNls
    public static final String WINDOWS_ME = "Windows Me";
    @NonNls
    public static final String SOLARIS = "Solaris";
    @NonNls
    public static final String MAC_OS_X = "Mac Os X";
    @NonNls
    public static final String LINUX = "Linux";

    private static HttpURLConnection post(String url, Map<String, String> params) throws IOException, MalformedURLException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        connection.setRequestMethod(HTTP_POST);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty(HTTP_CONTENT_TYPE, HTTP_WWW_FORM);
        StringBuffer buffer = new StringBuffer();
        for (String name : params.keySet()) {
            if (params.containsKey(name) && params.get(name) != null) {
                buffer.append(name + "=" + URLEncoder.encode(params.get(name), ENCODE) + POST_DELIMETER);
                continue;
            }
            throw new IllegalArgumentException(name);
        }
        connection.setRequestProperty(HTTP_CONTENT_LENGTH, Integer.toString(buffer.length()));
        connection.getOutputStream().write(buffer.toString().getBytes());
        return connection;
    }

    public static int postNewThread(String userName, String password, ErrorBean error, ExceptionBean e, String compilationTimestamp) throws IOException, NoSuchEAPUserException, InternalEAPException {
        int threadId;
        int c;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", userName);
        params.put("pwd", password);
        params.put("_title", MessageFormat.format(THREAD_SUBJECT, error.getLastAction() == null ? e.getExceptionClass() : error.getLastAction() + ", " + e.getExceptionClass()));
        ApplicationInfoEx appInfo = (ApplicationInfoEx)((Object)ApplicationManager.getApplication().getComponent(ApplicationInfo.class));
        params.put("_build", appInfo.getBuild().asString());
        params.put("_description", (compilationTimestamp != null ? "Build time: " + compilationTimestamp + "\n" : "") + error.getDescription() + "\n\n" + e.getStackTrace());
        String jdkVersion = SystemProperties.getJavaVersion();
        String jdkVendor = SystemProperties.getJavaVmVendor();
        jdkVersion = jdkVendor.indexOf(SUN) != -1 ? (jdkVersion.equals(JDK_1_4_2) ? "10" : (jdkVersion.equals(JDK_1_4_1) ? "7" : (jdkVersion.equals(JDK_1_4_0_02) ? "9" : (jdkVersion.equals(JDK_1_4_0_01) ? "8" : (jdkVersion.equals(JDK_1_4_0) ? "6" : (jdkVersion.equals(JDK_1_3_1_01) ? "5" : (jdkVersion.equals(JDK_1_3_1) ? "4" : (jdkVersion.equals(JDK_1_3_0) ? "3" : (jdkVersion.equals(JDK_1_2_2) ? "2" : "1"))))))))) : "1";
        params.put("_jdk", jdkVersion);
        String os = error.getOs();
        if (os == null) {
            os = "";
        }
        os = os.indexOf(WINDOWS_XP) != -1 ? "4" : (os.indexOf(WINDOWS_2000) != -1 || os.indexOf(WINDOWS_NT) != -1 ? "3" : (os.indexOf(WINDOWS_95) != -1 || os.indexOf(WINDOWS_98) != -1 || os.indexOf(WINDOWS_ME) != -1 ? "2" : (os.indexOf(SOLARIS) != -1 ? "7" : (os.indexOf(MAC_OS_X) != -1 ? "6" : (os.indexOf(LINUX) != -1 ? "5" : "1")))));
        params.put("_os", os);
        params.put("_product", ApplicationNamesInfo.getInstance().getProductName());
        HttpURLConnection connection = ITNProxy.post(NEW_THREAD_URL, params);
        int responce = connection.getResponseCode();
        switch (responce) {
            case 200: {
                break;
            }
            case 400: 
            case 404: {
                throw new NoSuchEAPUserException(userName);
            }
            default: {
                throw new InternalEAPException(DiagnosticBundle.message("error.http.result.code", responce));
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = connection.getInputStream();
        while ((c = is.read()) != -1) {
            baos.write(c);
        }
        try {
            threadId = Integer.valueOf(baos.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new InternalEAPException(DiagnosticBundle.message("error.itn.returns.wrong.data", new Object[0]));
        }
        return threadId;
    }
}

