/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints.actions;

import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class GotoSourceAction
extends BreakpointPanelAction {
    private final Project myProject;

    protected GotoSourceAction(Project project) {
        super(IdeBundle.message((String)"button.go.to", (Object[])new Object[0]));
        this.myProject = project;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.gotoSource();
    }

    private void gotoSource() {
        OpenFileDescriptor editSourceDescriptor = this.getPanel().createEditSourceDescriptor(this.myProject);
        if (editSourceDescriptor != null) {
            FileEditorManager.getInstance((Project)this.myProject).openTextEditor(editSourceDescriptor, true);
        }
    }

    @Override
    public void setButton(AbstractButton button) {
        super.setButton(button);
    }

    @Override
    public void setPanel(BreakpointPanel panel) {
        super.setPanel(panel);
        ShortcutSet shortcutSet = ActionManager.getInstance().getAction("EditSource").getShortcutSet();
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                GotoSourceAction.this.gotoSource();
            }
        }.registerCustomShortcutSet(shortcutSet, (JComponent)this.getPanel().getPanel());
    }

    @Override
    public void update() {
        this.getButton().setEnabled(this.getPanel().getCurrentViewableBreakpoint() != null);
    }
}

