/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadReferenceProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.ThreadReferenceProxyImpl");
    private String myName;
    private int myFrameCount = -1;
    private final List<StackFrameProxyImpl> myFramesFromBottom = new ArrayList<StackFrameProxyImpl>();
    private List<StackFrameProxyImpl> myFrames = null;
    private ThreadGroupReferenceProxyImpl myThreadGroupProxy;
    public static Comparator<ThreadReferenceProxyImpl> ourComparator = new Comparator<ThreadReferenceProxyImpl>(){

        @Override
        public int compare(ThreadReferenceProxyImpl th1, ThreadReferenceProxyImpl th2) {
            return th1.name().compareToIgnoreCase(th2.name());
        }
    };

    public ThreadReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadReference threadReference) {
        super(virtualMachineProxy, threadReference);
    }

    public ThreadReference getThreadReference() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (ThreadReference)this.getObjectReference();
    }

    public VirtualMachineProxyImpl getVirtualMachine() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public String name() {
        this.checkValid();
        if (this.myName == null) {
            try {
                this.myName = this.getThreadReference().name();
            }
            catch (ObjectCollectedException e) {
                this.myName = "";
            }
            catch (IllegalThreadStateException e) {
                this.myName = "zombie";
            }
        }
        return this.myName;
    }

    public int getSuspendCount() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.getThreadReference().suspendCount();
        }
        catch (ObjectCollectedException e) {
            return 0;
        }
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().suspend();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        this.clearCaches();
    }

    @Override
    @NonNls
    public String toString() {
        String threadRefString;
        try {
            threadRefString = this.getThreadReference().toString();
        }
        catch (ObjectCollectedException e) {
            threadRefString = "[thread collected]";
        }
        return "ThreadReferenceProxyImpl: " + threadRefString + " " + super.toString();
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadRef = this.getThreadReference();
        if (LOG.isDebugEnabled()) {
            LOG.debug("before resume" + threadRef);
        }
        this.getVirtualMachineProxy().clearCaches();
        try {
            threadRef.resume();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myFrames = null;
        this.myFrameCount = -1;
        super.clearCaches();
    }

    public int status() {
        try {
            return this.getThreadReference().status();
        }
        catch (ObjectCollectedException e) {
            return 0;
        }
    }

    public ThreadGroupReferenceProxyImpl threadGroupProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myThreadGroupProxy == null) {
            ThreadGroupReference threadGroupRef;
            try {
                threadGroupRef = this.getThreadReference().threadGroup();
            }
            catch (ObjectCollectedException e) {
                threadGroupRef = null;
            }
            this.myThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupRef);
        }
        return this.myThreadGroupProxy;
    }

    public int frameCount() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameCount == -1) {
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.myFrameCount = threadReference.frameCount();
            }
            catch (ObjectCollectedException e) {
                this.myFrameCount = 0;
            }
            catch (IncompatibleThreadStateException e) {
                if (!threadReference.isSuspended()) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                this.myFrameCount = 0;
            }
        }
        return this.myFrameCount;
    }

    public List<StackFrameProxyImpl> frames() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadRef = this.getThreadReference();
        try {
            this.checkValid();
            if (this.myFrames == null) {
                this.checkFrames(threadRef);
                this.myFrames = new ArrayList<StackFrameProxyImpl>(this.frameCount());
                ListIterator<StackFrameProxyImpl> iterator = this.myFramesFromBottom.listIterator(this.frameCount());
                while (iterator.hasPrevious()) {
                    StackFrameProxyImpl stackFrameProxy = iterator.previous();
                    this.myFrames.add(stackFrameProxy);
                }
            }
        }
        catch (ObjectCollectedException e) {
            return Collections.emptyList();
        }
        return this.myFrames;
    }

    private void checkFrames(@NotNull ThreadReference threadRef) throws EvaluateException {
        if (threadRef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/jdi/ThreadReferenceProxyImpl.checkFrames must not be null");
        }
        if (this.myFramesFromBottom.size() < this.frameCount()) {
            List<StackFrame> frames;
            int count = this.frameCount();
            try {
                frames = threadRef.frames(0, count - this.myFramesFromBottom.size());
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InternalException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            int index = this.myFramesFromBottom.size() + 1;
            ListIterator<StackFrame> iterator = frames.listIterator(count - this.myFramesFromBottom.size());
            while (iterator.hasPrevious()) {
                StackFrame stackFrame = iterator.previous();
                this.myFramesFromBottom.add(new StackFrameProxyImpl(this, stackFrame, index));
                ++index;
            }
        }
    }

    public StackFrameProxyImpl frame(int i) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (!threadReference.isSuspended()) {
                return null;
            }
            this.checkFrames(threadReference);
            int frameCount = this.frameCount();
            if (frameCount == 0) {
                return null;
            }
            return this.myFramesFromBottom.get(frameCount - i - 1);
        }
        catch (ObjectCollectedException e) {
            return null;
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    public void popFrames(StackFrameProxyImpl stackFrame) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().popFrames(stackFrame.getStackFrame());
        }
        catch (InvalidStackFrameException ignored) {
        }
        catch (ObjectCollectedException ignored) {
        }
        catch (InternalException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public boolean isSuspended() throws ObjectCollectedException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            return this.getThreadReference().isSuspended();
        }
        catch (IllegalThreadStateException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }
}

