/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.codeInsight.folding.impl.ExpandRegionHandler;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.PlaceInDocument;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleLineBreakpointActionHandler
extends DebuggerActionHandler {
    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/ToggleLineBreakpointActionHandler.isEnabled must not be null");
        }
        PlaceInDocument place = ToggleLineBreakpointActionHandler.getPlace(project, event);
        if (place != null) {
            Document document = place.getDocument();
            int offset = place.getOffset();
            int line = document.getLineNumber(offset);
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (DebuggerUtils.supportsJVMDebugging((FileType)file.getFileType()) || DebuggerUtils.supportsJVMDebugging((PsiFile)psiFile)) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
                return breakpointManager.findBreakpoint(document, offset, LineBreakpoint.CATEGORY) != null || LineBreakpoint.canAddLineBreakpoint(project, document, line);
            }
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/ToggleLineBreakpointActionHandler.perform must not be null");
        }
        PlaceInDocument place = ToggleLineBreakpointActionHandler.getPlace(project, event);
        if (place == null) {
            return;
        }
        ExpandRegionHandler.expandRegionAtCaret(project, (Editor)event.getData(PlatformDataKeys.EDITOR));
        Document document = place.getDocument();
        int line = document.getLineNumber(place.getOffset());
        DebuggerManagerEx debugManager = DebuggerManagerEx.getInstanceEx(project);
        if (debugManager == null) {
            return;
        }
        BreakpointManager manager = debugManager.getBreakpointManager();
        LineBreakpoint breakpoint = manager.findBreakpoint(document, place.getOffset(), LineBreakpoint.CATEGORY);
        if (breakpoint == null) {
            LineBreakpoint lineBreakpoint = manager.addLineBreakpoint(document, line);
            if (lineBreakpoint != null) {
                RequestManagerImpl.createRequests(lineBreakpoint);
            }
        } else {
            manager.removeBreakpoint(breakpoint);
        }
    }

    @Nullable
    private static PlaceInDocument getPlace(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/ToggleLineBreakpointActionHandler.getPlace must not be null");
        }
        Editor editor = (Editor)event.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        if (editor != null) {
            final Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file != null) {
                final Editor editor1 = editor;
                return new PlaceInDocument(){

                    @Override
                    public Document getDocument() {
                        return document;
                    }

                    @Override
                    public int getOffset() {
                        return editor1.getCaretModel().getOffset();
                    }
                };
            }
        }
        return null;
    }
}

