/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JobUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.concurrency.JobUtil");

    public static <T> boolean invokeConcurrentlyForAll(@NotNull Collection<T> things, final @NotNull Processor<T> thingProcessor, @NotNull @NonNls String jobName) throws ProcessCanceledException {
        if (things == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/concurrency/JobUtil.invokeConcurrentlyForAll must not be null");
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/concurrency/JobUtil.invokeConcurrentlyForAll must not be null");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/concurrency/JobUtil.invokeConcurrentlyForAll must not be null");
        }
        if (things.isEmpty()) {
            return true;
        }
        if (things.size() == 1) {
            T t = things.iterator().next();
            return thingProcessor.process(t);
        }
        final Job job = JobScheduler.getInstance().createJob(jobName, 100);
        for (final T thing : things) {
            job.addTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!thingProcessor.process(thing)) {
                            job.cancel();
                        }
                    }
                    catch (ProcessCanceledException e) {
                        job.cancel();
                        throw e;
                    }
                }
            });
        }
        try {
            job.scheduleAndWaitForResults();
        }
        catch (RuntimeException e) {
            job.cancel();
            throw e;
        }
        catch (Throwable throwable) {
            job.cancel();
            LOG.error(throwable);
        }
        return !job.isCanceled();
    }

    public static <T> boolean invokeConcurrentlyUnderMyProgress(@NotNull Collection<T> things, final @NotNull Processor<T> thingProcessor, @NotNull @NonNls String jobName) throws ProcessCanceledException {
        if (things == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/concurrency/JobUtil.invokeConcurrentlyUnderMyProgress must not be null");
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/concurrency/JobUtil.invokeConcurrentlyUnderMyProgress must not be null");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/concurrency/JobUtil.invokeConcurrentlyUnderMyProgress must not be null");
        }
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return JobUtil.invokeConcurrentlyForAll(things, new Processor<T>(){

            public boolean process(final T t) {
                final boolean[] result = new boolean[1];
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = thingProcessor.process(t);
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap(indicator));
                return result[0];
            }
        }, jobName);
    }
}

