/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;

public class JarDestinationInfo
extends DestinationInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo");
    private final String myPathInJar;
    private final JarInfo myJarInfo;

    public JarDestinationInfo(String pathInJar, JarInfo jarInfo, DestinationInfo jarDestination) {
        super(DeploymentUtil.appendToPath((String)jarDestination.getOutputPath(), (String)pathInJar), jarDestination.getOutputFile(), jarDestination.getOutputFilePath());
        LOG.assertTrue(!pathInJar.startsWith(".."), (Object)pathInJar);
        this.myPathInJar = StringUtil.startsWithChar((CharSequence)pathInJar, (char)'/') ? pathInJar : "/" + pathInJar;
        this.myJarInfo = jarInfo;
    }

    public String getPathInJar() {
        return this.myPathInJar;
    }

    public JarInfo getJarInfo() {
        return this.myJarInfo;
    }

    public String toString() {
        return this.myPathInJar + "(" + this.getOutputPath() + ")";
    }
}

