/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SpinAllocator;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NonNls;

public class CompilerParsingThread
implements Runnable,
OutputParser.Callback {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.JavaCompilerParsingThread");
    @NonNls
    public static final String TERMINATION_STRING = "__terminate_read__";
    private final Reader myCompilerOutStreamReader;
    private Process myProcess;
    private final OutputParser myOutputParser;
    private final boolean myTrimLines;
    private boolean mySkipLF = false;
    private Throwable myError = null;
    private final boolean myIsUnitTestMode;
    private FileObject myClassFileToProcess = null;
    private String myLastReadLine = null;
    private volatile boolean myProcessExited = false;
    private final CompileContext myContext;
    volatile boolean processing;

    public CompilerParsingThread(Process process, OutputParser outputParser, boolean readErrorStream, boolean trimLines, CompileContext context) {
        this.myProcess = process;
        this.myOutputParser = outputParser;
        this.myTrimLines = trimLines;
        InputStream stream = readErrorStream ? process.getErrorStream() : process.getInputStream();
        this.myCompilerOutStreamReader = stream == null ? null : new BufferedReader(new InputStreamReader(stream), 16384);
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.processing = true;
        try {
            while ((this.myIsUnitTestMode || this.myProcess != null) && !this.myProcessExited && !this.isCanceled() && this.myOutputParser.processMessageLine(this)) {
            }
            if (this.myClassFileToProcess != null) {
                this.processCompiledClass(this.myClassFileToProcess);
                this.myClassFileToProcess = null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.myError = e;
            LOG.info(e);
        }
        finally {
            this.killProcess();
            this.processing = false;
        }
    }

    private void killProcess() {
        if (this.myProcess != null) {
            this.myProcess.destroy();
            this.myProcess = null;
        }
    }

    public Throwable getError() {
        return this.myError;
    }

    @Override
    public String getCurrentLine() {
        return this.myLastReadLine;
    }

    @Override
    public final String getNextLine() {
        String line = this.readLine(this.myCompilerOutStreamReader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("LIne read: #" + line + "#");
        }
        this.myLastReadLine = TERMINATION_STRING.equals(line) ? null : (line == null ? null : (this.myTrimLines ? line.trim() : line));
        return this.myLastReadLine;
    }

    @Override
    public final void fileGenerated(FileObject path) {
        FileObject previousPath = this.myClassFileToProcess;
        this.myClassFileToProcess = path;
        if (previousPath != null) {
            try {
                this.processCompiledClass(previousPath);
            }
            catch (CacheCorruptedException e) {
                this.myError = e;
                LOG.info((Throwable)e);
                this.killProcess();
            }
        }
    }

    protected boolean isCanceled() {
        return this.myContext.getProgressIndicator().isCanceled();
    }

    @Override
    public void setProgressText(String text) {
        this.myContext.getProgressIndicator().setText(text);
    }

    @Override
    public void fileProcessed(String path) {
    }

    @Override
    public void message(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
        this.myContext.addMessage(category, message, url, lineNum, columnNum);
    }

    protected void processCompiledClass(FileObject classFileToProcess) throws CacheCorruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(Reader reader) {
        StringBuilder buffer;
        boolean releaseBuffer = true;
        try {
            buffer = StringBuilderSpinAllocator.alloc();
        }
        catch (SpinAllocator.AllocatorExhaustedException e) {
            LOG.info((Throwable)e);
            buffer = new StringBuilder();
            releaseBuffer = false;
        }
        try {
            int c;
            boolean first = true;
            while ((c = this.readNextByte(reader)) != -1) {
                first = false;
                if (c == 10) {
                    if (!this.mySkipLF) break;
                    this.mySkipLF = false;
                    continue;
                }
                if (c == 13) {
                    this.mySkipLF = true;
                    break;
                }
                this.mySkipLF = false;
                buffer.append((char)c);
            }
            if (first) {
                String string = null;
                return string;
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (releaseBuffer) {
                StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
            }
        }
    }

    private int readNextByte(Reader reader) {
        try {
            while (!reader.ready()) {
                if (this.isProcessTerminated()) {
                    return -1;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ignore) {}
            }
            return reader.read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private boolean isProcessTerminated() {
        return this.myProcessExited;
    }

    public void setProcessTerminated(boolean procesExited) {
        this.myProcessExited = procesExited;
    }
}

