/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.SignatureParsingException;
import com.intellij.openapi.compiler.CompilerBundle;
import java.text.CharacterIterator;

public class SignatureParser {
    public static final SignatureParser INSTANCE = new SignatureParser();

    public void parseIdentifier(CharacterIterator it, StringBuilder buf) {
        while (Character.isJavaIdentifierPart(it.current())) {
            buf.append(it.current());
            it.next();
        }
    }

    public void parseFormalTypeParameters(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() != '<') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{"<", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
        while (it.current() != '>') {
            this.parseFormalTypeParameter(it, buf);
        }
        buf.append(it.current());
        it.next();
    }

    public void parseFormalTypeParameter(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        this.parseIdentifier(it, buf);
        this.parseClassBound(it, buf);
        while (it.current() == ':') {
            this.parseInterfaceBound(it, buf);
        }
    }

    public void parseClassBound(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() != ':') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{":", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
        char current = it.current();
        if (current != '\uffff' && current != ':') {
            this.parseFieldTypeSignature(it, buf);
        }
    }

    public void parseInterfaceBound(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() != ':') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{":", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
        this.parseFieldTypeSignature(it, buf);
    }

    public void parseSuperclassSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        this.parseClassTypeSignature(it, buf);
    }

    public void parseSuperinterfaceSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        this.parseClassTypeSignature(it, buf);
    }

    public void parseFieldTypeSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() == 'L') {
            this.parseClassTypeSignature(it, buf);
        } else if (it.current() == '[') {
            this.parseArrayTypeSignature(it, buf);
        } else if (it.current() == 'T') {
            this.parseTypeVariableSignature(it, buf);
        } else {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{"'L' / '[' / 'T'", buf.toString()}));
        }
    }

    public void parseClassTypeSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        buf.append(it.current());
        it.next();
        this.parseSimpleClassTypeSignature(it, buf);
        while (it.current() == '/' || it.current() == '.') {
            this.parseClassTypeSignatureSuffix(it, buf);
        }
        if (it.current() != ';') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{";", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
    }

    public void parseSimpleClassTypeSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        this.parseIdentifier(it, buf);
        if (it.current() == '<') {
            this.parseTypeArguments(it, buf);
        }
    }

    public void parseClassTypeSignatureSuffix(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        buf.append(it.current());
        it.next();
        this.parseSimpleClassTypeSignature(it, buf);
    }

    public void parseTypeVariableSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        buf.append(it.current());
        it.next();
        this.parseIdentifier(it, buf);
        if (it.current() != ';') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{";", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
    }

    public void parseTypeArguments(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        buf.append(it.current());
        it.next();
        while (it.current() != '>') {
            this.parseTypeArgument(it, buf);
        }
        buf.append(it.current());
        it.next();
    }

    public void parseTypeArgument(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() == '*') {
            this.parseWildcardIndicator(it, buf);
        } else {
            if (it.current() == '+' || it.current() == '-') {
                this.parseWildcardIndicator(it, buf);
            }
            this.parseFieldTypeSignature(it, buf);
        }
    }

    public void parseWildcardIndicator(CharacterIterator it, StringBuilder buf) {
        buf.append(it.current());
        it.next();
    }

    public void parseArrayTypeSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        buf.append(it.current());
        it.next();
        this.parseTypeSignature(it, buf);
    }

    public void parseTypeSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        char current = it.current();
        if (current == 'B' || current == 'C' || current == 'D' || current == 'F' || current == 'I' || current == 'J' || current == 'S' || current == 'Z') {
            buf.append(it.current());
            it.next();
        } else if (current == 'L' || current == '[' || current == 'T') {
            this.parseFieldTypeSignature(it, buf);
        } else {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.unknown.type.signature", (Object[])new Object[0]));
        }
    }

    public void parseReturnType(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() == 'V') {
            buf.append(it.current());
            it.next();
        } else {
            this.parseTypeSignature(it, buf);
        }
    }

    public void parseThrowsSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() != '^') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{"^", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
        if (it.current() == 'T') {
            this.parseTypeVariableSignature(it, buf);
        } else {
            this.parseClassTypeSignature(it, buf);
        }
    }

    public void parseMethodSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() == '<') {
            this.parseFormalTypeParameters(it, buf);
        }
        if (it.current() != '(') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{"(", buf.toString()}));
        }
        buf.append(it.current());
        it.next();
        while (it.current() != ')') {
            this.parseTypeSignature(it, buf);
        }
        buf.append(it.current());
        it.next();
        this.parseReturnType(it, buf);
        if (it.current() != '\uffff') {
            this.parseThrowsSignature(it, buf);
        }
    }

    public void parseClassSignature(CharacterIterator it, StringBuilder buf) throws SignatureParsingException {
        if (it.current() == '<') {
            buf.append(it.current());
            it.next();
            while (it.current() != '>') {
                this.parseFormalTypeParameter(it, buf);
            }
            buf.append(it.current());
            it.next();
        }
        this.parseClassTypeSignature(it, buf);
        while (it.current() != '\uffff') {
            this.parseClassTypeSignature(it, buf);
        }
    }
}

