/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiFormatUtil;
import org.jdom.Element;

@Deprecated
public class XMLExportUtl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.util.XMLExportUtl");

    private XMLExportUtl() {
    }

    public static Element createElement(RefEntity refEntity, Element parentNode, int actualLine, TextRange range) {
        refEntity = refEntity.getRefManager().getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            PsiElement psiElement = refElement.getElement();
            PsiFile psiFile = psiElement.getContainingFile();
            Element fileElement = new Element("file");
            Element lineElement = new Element("line");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)refElement.getRefManager().getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                lineElement.addContent(String.valueOf(document.getLineNumber(psiElement.getTextOffset()) + 1));
            } else {
                lineElement.addContent(String.valueOf(actualLine));
            }
            problem.addContent(fileElement);
            problem.addContent(lineElement);
            XMLExportUtl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            XMLExportUtl.appendModule(problem, refModule);
            XMLExportUtl.appendFakePackage(problem);
        } else if (refEntity instanceof RefPackage) {
            Element packageElement = new Element("package");
            packageElement.addContent(refEntity.getName());
            problem.addContent(packageElement);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            XMLExportUtl.appendMethod(refMethod, problem);
        } else if (refEntity instanceof RefField) {
            RefField refField = (RefField)refEntity;
            XMLExportUtl.appendField(refField, problem);
        } else if (refEntity instanceof RefClass) {
            RefClass refClass = (RefClass)refEntity;
            XMLExportUtl.appendClass(refClass, problem);
        } else if (refEntity instanceof RefFile) {
            XMLExportUtl.appendFakePackage(problem);
        }
        parentNode.addContent(problem);
        return problem;
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    private static void appendFakePackage(Element problem) {
        Element fakePackage = new Element("package");
        fakePackage.addContent(InspectionsBundle.message((String)"inspection.export.results.default", (Object[])new Object[0]));
        problem.addContent(fakePackage);
    }

    private static void appendClass(RefClass refClass, Element parentNode) {
        PsiClass psiClass = refClass.getElement();
        PsiDocComment psiDocComment = psiClass.getDocComment();
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)psiFile).getPackageName();
            Element packageElement = new Element("package");
            packageElement.addContent(packageName.length() > 0 ? packageName : InspectionsBundle.message((String)"inspection.export.results.default", (Object[])new Object[0]));
            parentNode.addContent(packageElement);
        }
        Element classElement = new Element("class");
        if (psiDocComment != null) {
            PsiDocTag[] tags;
            for (PsiDocTag tag : tags = psiDocComment.getTags()) {
                if (!"author".equals(tag.getName()) || tag.getValueElement() == null) continue;
                classElement.setAttribute("author", tag.getValueElement().getText());
            }
        }
        String name = PsiFormatUtil.formatClass((PsiClass)psiClass, (int)1);
        Element nameElement = new Element("name");
        nameElement.addContent(name);
        classElement.addContent(nameElement);
        Element displayName = new Element("display_name");
        displayName.addContent(refClass.getQualifiedName());
        classElement.addContent(displayName);
        parentNode.addContent(classElement);
        RefClass topClass = RefJavaUtil.getInstance().getTopLevelClass((RefElement)refClass);
        if (topClass != refClass) {
            XMLExportUtl.appendClass(topClass, classElement);
        }
    }

    private static void appendMethod(RefMethod refMethod, Element parentNode) {
        Element methodElement = new Element(refMethod.isConstructor() ? "constructor" : "method");
        PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
        String name = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)2307, (int)3);
        Element shortNameElement = new Element("name");
        shortNameElement.addContent(name);
        methodElement.addContent(shortNameElement);
        Element displayName = new Element("name");
        displayName.addContent(refMethod.getQualifiedName());
        methodElement.addContent(displayName);
        XMLExportUtl.appendClass(RefJavaUtil.getInstance().getTopLevelClass((RefElement)refMethod), methodElement);
        parentNode.addContent(methodElement);
    }

    private static void appendField(RefField refField, Element parentNode) {
        Element fieldElement = new Element("field");
        PsiField psiField = refField.getElement();
        String name = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        Element shortNameElement = new Element("name");
        shortNameElement.addContent(name);
        fieldElement.addContent(shortNameElement);
        Element displayName = new Element("display_name");
        displayName.addContent(refField.getQualifiedName());
        fieldElement.addContent(displayName);
        XMLExportUtl.appendClass(RefJavaUtil.getInstance().getTopLevelClass((RefElement)refField), fieldElement);
        parentNode.addContent(fieldElement);
    }
}

