/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionWrapper
extends ActionGroup {
    private final Project myProject;
    private final InspectionManagerEx myManager;
    private final Set<InspectionTreeNode> myNodesToSuppress = new HashSet();
    private final InspectionTool myTool;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.actions.SuppressActionWrapper");

    public SuppressActionWrapper(Project project, InspectionTool tool, TreePath[] paths) {
        super(InspectionsBundle.message((String)"suppress.inspection.problem", (Object[])new Object[0]), false);
        this.myProject = project;
        this.myManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (!(node instanceof TreeNode)) continue;
            TreeUtil.traverse((TreeNode)((TreeNode)node), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    InspectionTreeNode n = (InspectionTreeNode)node;
                    if (n.isLeaf()) {
                        SuppressActionWrapper.this.myNodesToSuppress.add(n);
                    }
                    return true;
                }
            });
        }
        this.myTool = tool;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SuppressTreeAction[] getChildren(@Nullable AnActionEvent e) {
        SuppressTreeAction[] suppressTreeActionArray;
        SuppressIntentionAction[] suppressActions = this.myTool.getSuppressActions();
        if (suppressActions == null || suppressActions.length == 0) {
            suppressTreeActionArray = new SuppressTreeAction[]{};
            if (suppressTreeActionArray == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ui/actions/SuppressActionWrapper.getChildren must not return null");
            return suppressTreeActionArray;
        }
        SuppressTreeAction[] actions = new SuppressTreeAction[suppressActions.length];
        for (int i = 0; i < suppressActions.length; ++i) {
            SuppressIntentionAction suppressAction = suppressActions[i];
            actions[i] = new SuppressTreeAction(suppressAction);
        }
        suppressTreeActionArray = actions;
        if (actions != null) return suppressTreeActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ui/actions/SuppressActionWrapper.getChildren must not return null");
    }

    private boolean suppress(final PsiElement element, final SuppressIntentionAction action) {
        final PsiModificationTracker tracker = PsiManager.getInstance((Project)this.myProject).getModificationTracker();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)SuppressActionWrapper.this.myProject).commitAllDocuments();
                try {
                    long startModificationCount = tracker.getModificationCount();
                    if (action.isAvailable(SuppressActionWrapper.this.myProject, null, element)) {
                        action.invoke(SuppressActionWrapper.this.myProject, null, element);
                    }
                    if (startModificationCount != tracker.getModificationCount()) {
                        Set<GlobalInspectionContextImpl> globalInspectionContexts = SuppressActionWrapper.this.myManager.getRunningContexts();
                        for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                            context.ignoreElement(SuppressActionWrapper.this.myTool, element);
                        }
                    }
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        });
        return true;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.myTool != null && this.myTool.getSuppressActions() != null);
    }

    private static Pair<PsiElement, CommonProblemDescriptor> getContentToSuppress(InspectionTreeNode node) {
        RefElement refElement = null;
        CommonProblemDescriptor descriptor = null;
        if (node instanceof RefElementNode) {
            RefElementNode elementNode = (RefElementNode)node;
            RefEntity element = elementNode.getElement();
            refElement = element instanceof RefElement ? (RefElement)element : null;
            descriptor = elementNode.getProblem();
        } else if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode descriptionNode = (ProblemDescriptionNode)node;
            RefEntity element = descriptionNode.getElement();
            refElement = element instanceof RefElement ? (RefElement)element : null;
            descriptor = descriptionNode.getDescriptor();
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement != null ? refElement.getElement() : null);
        return Pair.create((Object)element, descriptor);
    }

    public class SuppressTreeAction
    extends AnAction {
        private final SuppressIntentionAction mySuppressAction;

        public SuppressTreeAction(SuppressIntentionAction suppressAction) {
            super(suppressAction.getText());
            this.mySuppressAction = suppressAction;
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(SuppressActionWrapper.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            for (InspectionTreeNode node : SuppressActionWrapper.this.myNodesToSuppress) {
                                PsiElement element;
                                Pair content = SuppressActionWrapper.getContentToSuppress(node);
                                if (content.first != null && SuppressActionWrapper.this.suppress(element = (PsiElement)content.first, SuppressTreeAction.this.mySuppressAction)) continue;
                                break;
                            }
                            Set<GlobalInspectionContextImpl> globalInspectionContexts = SuppressActionWrapper.this.myManager.getRunningContexts();
                            for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                                context.refreshViews();
                            }
                        }
                    }, SuppressTreeAction.this.getTemplatePresentation().getText(), null);
                }
            });
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (!this.isAvailable()) {
                e.getPresentation().setVisible(false);
            }
        }

        public boolean isAvailable() {
            for (InspectionTreeNode node : SuppressActionWrapper.this.myNodesToSuppress) {
                Pair content = SuppressActionWrapper.getContentToSuppress(node);
                if (content.first == null) continue;
                PsiElement element = (PsiElement)content.first;
                if (!this.mySuppressAction.isAvailable(SuppressActionWrapper.this.myProject, null, element)) continue;
                return true;
            }
            return false;
        }
    }
}

