/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptorNode
extends ProblemDescriptionNode {
    public OfflineProblemDescriptorNode(OfflineProblemDescriptor descriptor, DescriptorProviderInspection tool) {
        super((Object)descriptor, tool);
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        if (this.userObject instanceof CommonProblemDescriptor) {
            return this.myElement;
        }
        if (this.userObject == null) {
            return null;
        }
        this.myElement = ((OfflineProblemDescriptor)this.userObject).getRefElement(this.myTool.getContext().getRefManager());
        return this.myElement;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        if (this.userObject == null) {
            return null;
        }
        if (this.userObject instanceof CommonProblemDescriptor) {
            return (CommonProblemDescriptor)this.userObject;
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.myTool.getContext().getProject());
        OfflineProblemDescriptor offlineProblemDescriptor = (OfflineProblemDescriptor)this.userObject;
        RefEntity element = this.getElement();
        if (this.myTool instanceof LocalInspectionToolWrapper) {
            PsiElement psiElement;
            if (element instanceof RefElement && (psiElement = ((RefElement)element).getElement()) != null) {
                PsiElement[] elementsInRange;
                PsiFile containingFile = psiElement.getContainingFile();
                ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
                LocalInspectionTool localInspectionTool = ((LocalInspectionToolWrapper)this.myTool).getTool();
                PsiElementVisitor visitor = localInspectionTool.buildVisitor(holder, false);
                for (PsiElement el : elementsInRange = LocalInspectionsPass.getElementsIntersectingRange(containingFile, psiElement.getTextRange().getStartOffset(), psiElement.getTextRange().getEndOffset())) {
                    el.accept(visitor);
                }
                if (holder.hasResults()) {
                    List list = holder.getResults();
                    int idx = offlineProblemDescriptor.getProblemIndex();
                    if (list != null) {
                        int curIdx = 0;
                        for (ProblemDescriptor descriptor : list) {
                            PsiNamedElement member = localInspectionTool.getProblemElement(descriptor.getPsiElement());
                            if (!(psiElement instanceof PsiFile) && (member == null || !member.equals(psiElement))) continue;
                            if (curIdx == idx) {
                                this.setUserObject(descriptor);
                                return descriptor;
                            }
                            ++curIdx;
                        }
                    }
                }
            }
            this.setUserObject(null);
            return null;
        }
        List hints = offlineProblemDescriptor.getHints();
        if (element instanceof RefElement) {
            PsiElement psiElement = ((RefElement)element).getElement();
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(psiElement, offlineProblemDescriptor.getDescription(), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
            LocalQuickFix[] quickFixes = this.getFixes((CommonProblemDescriptor)descriptor, hints);
            if (quickFixes != null) {
                descriptor = inspectionManager.createProblemDescriptor(psiElement, offlineProblemDescriptor.getDescription(), false, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            this.setUserObject(descriptor);
            return descriptor;
        }
        CommonProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), new QuickFix[]{null});
        LocalQuickFix[] quickFixes = this.getFixes(descriptor, hints);
        if (quickFixes != null) {
            descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), (QuickFix[])quickFixes);
        }
        this.setUserObject(descriptor);
        return descriptor;
    }

    @Nullable
    private LocalQuickFix[] getFixes(CommonProblemDescriptor descriptor, List<String> hints) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (hints == null) {
            this.addFix(descriptor, fixes, null);
        } else {
            for (String hint : hints) {
                this.addFix(descriptor, fixes, hint);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private void addFix(CommonProblemDescriptor descriptor, List<LocalQuickFix> fixes, String hint) {
        IntentionAction intentionAction = this.myTool.findQuickFixes(descriptor, hint);
        if (intentionAction instanceof QuickFixWrapper) {
            fixes.add(((QuickFixWrapper)intentionAction).getFix());
        }
    }

    @Override
    public boolean isValid() {
        return this.getDescriptor() != null && super.isValid();
    }
}

