/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ReorderableListController;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SeverityEditorDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JList myOptionsList = new JList();
    private final ColorAndFontDescriptionPanel myOptionsPanel = new ColorAndFontDescriptionPanel();
    private SeverityRegistrar.SeverityBasedTextAttributes myCurrentSelection;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.SeverityEditorDialog");
    private final SeverityRegistrar mySeverityRegistrar;
    private final CardLayout myCard;
    private final JPanel myRightPanel;
    @NonNls
    private static final String DEFAULT = "DEFAULT";
    @NonNls
    private static final String EDITABLE = "EDITABLE";

    public SeverityEditorDialog(JComponent parent, HighlightSeverity severity, SeverityRegistrar severityRegistrar) {
        super((Component)parent, true);
        this.mySeverityRegistrar = severityRegistrar;
        this.myOptionsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof SeverityRegistrar.SeverityBasedTextAttributes) {
                    this.setText(((SeverityRegistrar.SeverityBasedTextAttributes)value).getSeverity().toString());
                }
                return rendererComponent;
            }
        });
        this.myOptionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SeverityEditorDialog.this.myCurrentSelection != null) {
                    SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
                }
                SeverityEditorDialog.this.myCurrentSelection = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue();
                if (SeverityEditorDialog.this.myCurrentSelection != null) {
                    SeverityEditorDialog.this.reset(SeverityEditorDialog.this.myCurrentSelection);
                    SeverityEditorDialog.this.myCard.show(SeverityEditorDialog.this.myRightPanel, SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(SeverityEditorDialog.this.myCurrentSelection.getSeverity()) ? SeverityEditorDialog.DEFAULT : SeverityEditorDialog.EDITABLE);
                }
            }
        });
        this.myOptionsList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.myOptionsList);
        scrollPane.setPreferredSize(new Dimension(230, 60));
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)scrollPane, "Center");
        leftPanel.add((Component)this.createListToolbar(), "North");
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)leftPanel, "West");
        this.myCard = new CardLayout();
        this.myRightPanel = new JPanel(this.myCard);
        JPanel disabled = new JPanel(new GridBagLayout());
        JButton button = new JButton(InspectionsBundle.message((String)"severities.default.settings.message", (Object[])new Object[0]));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String toConfigure = SeverityEditorDialog.this.getSelectedType().getSeverity(null).myName;
                SeverityEditorDialog.this.doOKAction();
                SeverityEditorDialog.this.myOptionsList.clearSelection();
                ColorAndFontOptions colorAndFontOptions = null;
                for (EditorOptionsProvider provider : (EditorOptionsProvider[])Extensions.getExtensions(EditorOptionsProvider.EP_NAME)) {
                    if (!provider.getClass().isAssignableFrom(ColorAndFontOptions.class)) continue;
                    colorAndFontOptions = (ColorAndFontOptions)provider;
                    break;
                }
                assert (colorAndFontOptions != null);
                final ColorAndFontOptions.InnerSearchableConfigurable javaPage = colorAndFontOptions.findSubConfigurable(InspectionColorSettingsPage.class);
                LOG.assertTrue(javaPage != null);
                OptionsEditor optionsEditor = (OptionsEditor)OptionsEditor.KEY.getData(DataManager.getInstance().getDataContext());
                if (optionsEditor != null) {
                    optionsEditor.select((Configurable)javaPage).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            Runnable runnable = javaPage.enableSearch(toConfigure);
                            if (runnable != null) {
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                    });
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), (Configurable)javaPage);
                }
            }
        });
        disabled.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myRightPanel.add(DEFAULT, disabled);
        this.myRightPanel.add(EDITABLE, this.myOptionsPanel);
        this.myCard.show(this.myRightPanel, EDITABLE);
        this.myPanel.add((Component)this.myRightPanel, "Center");
        this.fillList(severity);
        this.init();
        this.setTitle(InspectionsBundle.message((String)"severities.editor.dialog.title", (Object[])new Object[0]));
        this.reset((SeverityRegistrar.SeverityBasedTextAttributes)this.myOptionsList.getSelectedValue());
    }

    private void fillList(HighlightSeverity severity) {
        DefaultListModel<SeverityRegistrar.SeverityBasedTextAttributes> model = new DefaultListModel<SeverityRegistrar.SeverityBasedTextAttributes>();
        model.removeAllElements();
        ArrayList<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = new ArrayList<SeverityRegistrar.SeverityBasedTextAttributes>();
        infoTypes.addAll(this.mySeverityRegistrar.getRegisteredHighlightingInfoTypes());
        Collections.sort(infoTypes, new Comparator<SeverityRegistrar.SeverityBasedTextAttributes>(){

            @Override
            public int compare(SeverityRegistrar.SeverityBasedTextAttributes attributes1, SeverityRegistrar.SeverityBasedTextAttributes attributes2) {
                return -SeverityEditorDialog.this.mySeverityRegistrar.compare(attributes1.getSeverity(), attributes2.getSeverity());
            }
        });
        SeverityRegistrar.SeverityBasedTextAttributes preselection = null;
        for (SeverityRegistrar.SeverityBasedTextAttributes type : infoTypes) {
            model.addElement(type);
            if (!type.getSeverity().equals((Object)severity)) continue;
            preselection = type;
        }
        this.myOptionsList.setModel(model);
        this.myOptionsList.setSelectedValue(preselection, true);
    }

    private void apply(SeverityRegistrar.SeverityBasedTextAttributes info) {
        MyTextAttributesDescription description = new MyTextAttributesDescription(info.getType().toString(), null, new TextAttributes(), info.getType().getAttributesKey());
        this.myOptionsPanel.apply(description, null);
        Element textAttributes = new Element("temp");
        try {
            description.getTextAttributes().writeExternal(textAttributes);
            info.getAttributes().readExternal(textAttributes);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void reset(SeverityRegistrar.SeverityBasedTextAttributes info) {
        MyTextAttributesDescription description = new MyTextAttributesDescription(info.getType().toString(), null, info.getAttributes(), info.getType().getAttributesKey());
        Element textAttributes = new Element("temp");
        try {
            info.getAttributes().writeExternal(textAttributes);
            description.getTextAttributes().readExternal(textAttributes);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        this.myOptionsPanel.reset(description);
    }

    private JComponent createListToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        ReorderableListController controller = ReorderableListController.create((JList)this.myOptionsList, (DefaultActionGroup)group);
        controller.addAddAction(IdeBundle.message((String)"action.add", (Object[])new Object[0]), (Factory)new Factory<SeverityRegistrar.SeverityBasedTextAttributes>(){

            @Nullable
            public SeverityRegistrar.SeverityBasedTextAttributes create() {
                String name = Messages.showInputDialog((Component)SeverityEditorDialog.this.myPanel, (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.name.label", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        ListModel listModel = SeverityEditorDialog.this.myOptionsList.getModel();
                        for (int i = 0; i < listModel.getSize(); ++i) {
                            String severityName = ((SeverityRegistrar.SeverityBasedTextAttributes)listModel.getElementAt((int)i)).getSeverity().myName;
                            if (!Comparing.strEqual((String)severityName, (String)inputString)) continue;
                            return false;
                        }
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (name == null) {
                    return null;
                }
                TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(name, 50), TextAttributesKey.createTextAttributesKey((String)name));
                return new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info);
            }
        }, true);
        ReorderableListController.RemoveActionDescription removeAction = controller.addRemoveAction(IdeBundle.message((String)"action.remove", (Object[])new Object[0]));
        removeAction.setEnableCondition((Condition)new Condition<SeverityRegistrar.SeverityBasedTextAttributes>(){

            public boolean value(SeverityRegistrar.SeverityBasedTextAttributes pair) {
                return !SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity());
            }
        });
        controller.addAction((AnAction)new MyMoveUpAction());
        controller.addAction((AnAction)new MyMoveDownAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    protected void doOKAction() {
        this.apply((SeverityRegistrar.SeverityBasedTextAttributes)this.myOptionsList.getSelectedValue());
        HashSet<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = new HashSet<SeverityRegistrar.SeverityBasedTextAttributes>(this.mySeverityRegistrar.getRegisteredHighlightingInfoTypes());
        ListModel listModel = this.myOptionsList.getModel();
        ArrayList<String> order = new ArrayList<String>();
        for (int i = listModel.getSize() - 1; i >= 0; --i) {
            SeverityRegistrar.SeverityBasedTextAttributes info = (SeverityRegistrar.SeverityBasedTextAttributes)listModel.getElementAt(i);
            order.add(info.getSeverity().myName);
            if (this.mySeverityRegistrar.isDefaultSeverity(info.getSeverity())) continue;
            infoTypes.remove(info);
            Color stripeColor = info.getAttributes().getErrorStripeColor();
            this.mySeverityRegistrar.registerSeverity(info, stripeColor != null ? stripeColor : LightColors.YELLOW);
        }
        for (SeverityRegistrar.SeverityBasedTextAttributes info : infoTypes) {
            this.mySeverityRegistrar.unregisterSeverity(info.getSeverity());
        }
        this.mySeverityRegistrar.setOrder(order);
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public HighlightInfoType getSelectedType() {
        SeverityRegistrar.SeverityBasedTextAttributes selection = (SeverityRegistrar.SeverityBasedTextAttributes)this.myOptionsList.getSelectedValue();
        return selection != null ? selection.getType() : null;
    }

    private class MyMoveDownAction
    extends AnAction {
        public MyMoveDownAction() {
            super(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/moveDown.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
            ListUtil.moveSelectedItemsDown((JList)SeverityEditorDialog.this.myOptionsList);
        }

        public void update(AnActionEvent e) {
            SeverityRegistrar.SeverityBasedTextAttributes pair;
            boolean canMove = ListUtil.canMoveSelectedItemsDown((JList)SeverityEditorDialog.this.myOptionsList);
            if (canMove && (pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue()) != null && SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                int newPosition = SeverityEditorDialog.this.myOptionsList.getSelectedIndex() + 1;
                pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getModel().getElementAt(newPosition);
                if (SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                    canMove = false;
                }
            }
            e.getPresentation().setEnabled(canMove);
        }
    }

    private class MyMoveUpAction
    extends AnAction {
        public MyMoveUpAction() {
            super(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/moveUp.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
            ListUtil.moveSelectedItemsUp((JList)SeverityEditorDialog.this.myOptionsList);
        }

        public void update(AnActionEvent e) {
            SeverityRegistrar.SeverityBasedTextAttributes pair;
            boolean canMove = ListUtil.canMoveSelectedItemsUp((JList)SeverityEditorDialog.this.myOptionsList);
            if (canMove && (pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue()) != null && SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                int newPosition = SeverityEditorDialog.this.myOptionsList.getSelectedIndex() - 1;
                pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getModel().getElementAt(newPosition);
                if (SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                    canMove = false;
                }
            }
            e.getPresentation().setEnabled(canMove);
        }
    }

    private static class MyTextAttributesDescription
    extends TextAttributesDescription {
        public MyTextAttributesDescription(String name, String group, TextAttributes attributes, TextAttributesKey type) {
            super(name, group, attributes, type, null, null, null);
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return super.getTextAttributes();
        }
    }
}

