/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)("#" + InspectionRVContentProvider.class.getName()));

    public InspectionRVContentProvider(Project project) {
        this.myProject = project;
    }

    public abstract boolean checkReportedProblems(InspectionTool var1);

    @Nullable
    public abstract QuickFixAction[] getQuickFixes(InspectionTool var1, InspectionTree var2);

    public abstract void appendToolNodeContent(InspectionNode var1, InspectionTreeNode var2, boolean var3);

    protected abstract void appendDescriptor(InspectionTool var1, UserObjectContainer var2, InspectionPackageNode var3, boolean var4);

    public boolean isContentLoaded() {
        return true;
    }

    protected <T> List<InspectionTreeNode> buildTree(Map<String, Set<T>> packageContents, boolean canPackageRepeat, InspectionTool tool, Function<T, UserObjectContainer<T>> computeContainer, boolean showStructure) {
        ArrayList<InspectionTreeNode> content = new ArrayList<InspectionTreeNode>();
        HashMap module2PackageMap = new HashMap();
        boolean supportStructure = showStructure;
        for (String packageName : packageContents.keySet()) {
            Set<T> elements = packageContents.get(packageName);
            for (T userObject : elements) {
                InspectionPackageNode pNode;
                UserObjectContainer container = (UserObjectContainer)computeContainer.fun(userObject);
                supportStructure &= container.supportStructure();
                String moduleName = showStructure ? container.getModule() : null;
                HashMap<String, InspectionPackageNode> packageNodes = (HashMap<String, InspectionPackageNode>)module2PackageMap.get(moduleName);
                if (packageNodes == null) {
                    packageNodes = new HashMap<String, InspectionPackageNode>();
                    module2PackageMap.put(moduleName, packageNodes);
                }
                if ((pNode = (InspectionPackageNode)packageNodes.get(packageName)) == null) {
                    pNode = new InspectionPackageNode(packageName);
                    packageNodes.put(packageName, pNode);
                }
                this.appendDescriptor(tool, container, pNode, canPackageRepeat);
            }
        }
        if (supportStructure) {
            HashMap<String, InspectionModuleNode> moduleNodes = new HashMap<String, InspectionModuleNode>();
            block2: for (String moduleName : module2PackageMap.keySet()) {
                Map packageNodes = (Map)module2PackageMap.get(moduleName);
                for (InspectionPackageNode packageNode : packageNodes.values()) {
                    if (packageNode.getChildCount() <= 0) continue;
                    InspectionModuleNode moduleNode = (InspectionModuleNode)moduleNodes.get(moduleName);
                    if (moduleNode == null) {
                        if (moduleName != null) {
                            Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName);
                            if (module == null) continue;
                            moduleNode = new InspectionModuleNode(module);
                            moduleNodes.put(moduleName, moduleNode);
                        } else {
                            content.addAll(packageNodes.values());
                            continue block2;
                        }
                    }
                    if (packageNode.getPackageName() != null) {
                        moduleNode.add(packageNode);
                        continue;
                    }
                    for (int i = packageNode.getChildCount() - 1; i >= 0; --i) {
                        moduleNode.add((MutableTreeNode)packageNode.getChildAt(i));
                    }
                }
            }
            content.addAll(moduleNodes.values());
        } else {
            for (Map packageNodes : module2PackageMap.values()) {
                block6: for (InspectionPackageNode pNode : packageNodes.values()) {
                    for (int i = 0; i < pNode.getChildCount(); ++i) {
                        TreeNode childNode = pNode.getChildAt(i);
                        if (childNode instanceof ProblemDescriptionNode) {
                            content.add(pNode);
                            continue block6;
                        }
                        LOG.assertTrue(childNode instanceof RefElementNode, (Object)childNode.getClass().getName());
                        RefElementNode elementNode = (RefElementNode)childNode;
                        HashSet parentNodes = new HashSet();
                        if (pNode.getPackageName() != null) {
                            parentNodes.add(elementNode);
                        } else {
                            boolean hasElementNodeUnder = true;
                            for (int e = 0; e < elementNode.getChildCount(); ++e) {
                                TreeNode grandChildNode = elementNode.getChildAt(e);
                                if (grandChildNode instanceof ProblemDescriptionNode) {
                                    hasElementNodeUnder = false;
                                    break;
                                }
                                LOG.assertTrue(grandChildNode instanceof RefElementNode);
                                parentNodes.add((RefElementNode)grandChildNode);
                            }
                            if (!hasElementNodeUnder) {
                                content.add(elementNode);
                                continue;
                            }
                        }
                        for (RefElementNode parentNode : parentNodes) {
                            final ArrayList nodes = new ArrayList();
                            TreeUtil.traverse((TreeNode)parentNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                                public boolean accept(Object node) {
                                    if (node instanceof ProblemDescriptionNode) {
                                        nodes.add((ProblemDescriptionNode)node);
                                    }
                                    return true;
                                }
                            });
                            if (nodes.isEmpty()) continue;
                            parentNode.removeAllChildren();
                            for (ProblemDescriptionNode node : nodes) {
                                parentNode.add(node);
                            }
                        }
                        content.addAll((Collection<InspectionTreeNode>)parentNodes);
                    }
                }
            }
        }
        return content;
    }

    protected static RefElementNode addNodeToParent(UserObjectContainer container, InspectionTool tool, InspectionTreeNode parentNode) {
        THashSet children = new THashSet(1000);
        TreeUtil.traverseDepth((TreeNode)parentNode, (TreeUtil.Traverse)new TreeUtil.Traverse((Set)children){
            final /* synthetic */ Set val$children;
            {
                this.val$children = set;
            }

            public boolean accept(Object node) {
                this.val$children.add((InspectionTreeNode)node);
                return true;
            }
        });
        RefElementNode nodeToBeAdded = container.createNode(tool);
        boolean firstLevel = true;
        RefElementNode prevNode = null;
        while (true) {
            UserObjectContainer<Object> owner;
            RefElementNode currentNode = firstLevel ? nodeToBeAdded : container.createNode(tool);
            for (InspectionTreeNode node : children) {
                RefElementNode refElementNode;
                if (!(node instanceof RefElementNode) || !container.areEqual((refElementNode = (RefElementNode)node).getUserObject(), container.getUserObject())) continue;
                if (firstLevel) {
                    return refElementNode;
                }
                refElementNode.add(prevNode);
                return nodeToBeAdded;
            }
            if (!firstLevel) {
                currentNode.add(prevNode);
            }
            if ((owner = container.getOwner()) == null) {
                parentNode.add(currentNode);
                return nodeToBeAdded;
            }
            container = owner;
            prevNode = currentNode;
            firstLevel = false;
        }
    }

    protected static void merge(InspectionTreeNode child, InspectionTreeNode parent, boolean merge) {
        if (merge) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                InspectionTreeNode current = (InspectionTreeNode)parent.getChildAt(i);
                if (child.getClass() != current.getClass()) continue;
                if (current instanceof InspectionPackageNode) {
                    if (((InspectionPackageNode)current).getPackageName().compareTo(((InspectionPackageNode)child).getPackageName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return;
                }
                if (current instanceof RefElementNode) {
                    if (((RefElementNode)current).getElement().getName().compareTo(((RefElementNode)child).getElement().getName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return;
                }
                if (current instanceof InspectionNode) {
                    if (((InspectionNode)current).getTool().getShortName().compareTo(((InspectionNode)child).getTool().getShortName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return;
                }
                if (current instanceof InspectionModuleNode) {
                    if (((InspectionModuleNode)current).getName().compareTo(((InspectionModuleNode)child).getName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return;
                }
                if (!(current instanceof ProblemDescriptionNode) || ((ProblemDescriptionNode)current).getDescriptor().getDescriptionTemplate().compareTo(((ProblemDescriptionNode)child).getDescriptor().getDescriptionTemplate()) != 0) continue;
                InspectionRVContentProvider.processDepth(child, current);
                return;
            }
        }
        parent.add(child);
    }

    private static void processDepth(InspectionTreeNode child, InspectionTreeNode current) {
        for (int j = 0; j < child.getChildCount(); ++j) {
            InspectionRVContentProvider.merge((InspectionTreeNode)child.getChildAt(j), current, true);
        }
    }

    protected static interface UserObjectContainer<T> {
        @Nullable
        public UserObjectContainer<T> getOwner();

        public RefElementNode createNode(InspectionTool var1);

        public T getUserObject();

        @Nullable
        public String getModule();

        public boolean areEqual(T var1, T var2);

        public boolean supportStructure();
    }
}

