/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;

public abstract class BranchingInstruction
extends Instruction {
    private boolean myIsTrueReachable = false;
    private boolean myIsFalseReachable = false;
    private boolean isConstTrue;
    private PsiElement myExpression;

    protected BranchingInstruction() {
        this.setPsiAnchor(null);
    }

    public boolean isTrueReachable() {
        return this.myIsTrueReachable;
    }

    public boolean isFalseReachable() {
        return this.myIsFalseReachable;
    }

    public PsiElement getPsiAnchor() {
        return this.myExpression;
    }

    public void setTrueReachable() {
        this.myIsTrueReachable = true;
    }

    public void setFalseReachable() {
        this.myIsFalseReachable = true;
    }

    public boolean isConditionConst() {
        return !this.isConstTrue && this.myIsTrueReachable != this.myIsFalseReachable;
    }

    private static boolean isBoolConst(PsiElement condition) {
        if (!(condition instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = condition.getText();
        return "true".equals(text) || "false".equals(text);
    }

    protected void setPsiAnchor(PsiElement psiAcnchor) {
        this.myExpression = psiAcnchor;
        this.isConstTrue = psiAcnchor != null && BranchingInstruction.isBoolConst(psiAcnchor);
    }
}

