/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.ui.popup.PopupUpdateProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ShowImplementationsAction
extends AnAction {
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE = "codeassists.quickdefinition.lookup";
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_FEATURE = "codeassists.quickdefinition";

    public ShowImplementationsAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        this.performForContext(e.getDataContext());
    }

    public void performForContext(DataContext dataContext) {
        PsiElement element;
        boolean isInvokedFromEditor;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        boolean bl = isInvokedFromEditor = editor != null;
        if (editor != null) {
            element = TargetElementUtilBase.findTargetElement(editor, TargetElementUtilBase.getInstance().getAllAccepted());
        } else {
            FileEditor fileEditor;
            element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
            if (file != null && (fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file.getVirtualFile())) instanceof TextEditor) {
                editor = ((TextEditor)fileEditor).getEditor();
            }
        }
        String text = "";
        PsiElement[] impls = new PsiElement[]{};
        PsiReference ref = null;
        PsiElement adjustedElement = TargetElementUtilBase.getInstance().adjustElement(editor, TargetElementUtilBase.getInstance().getAllAccepted(), element, null);
        if (adjustedElement != null) {
            element = adjustedElement;
        } else if (file != null && editor != null) {
            element = DocumentationManager.getInstance(project).getElementFromLookup(editor, file);
        }
        if (editor != null) {
            ref = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset());
            if (element == null && ref != null) {
                element = TargetElementUtilBase.getInstance().adjustReference(ref);
            }
        }
        if (element != null) {
            impls = ShowImplementationsAction.getSelfAndImplementations(editor, element);
            text = SymbolPresentationUtil.getSymbolPresentableText(element);
        }
        if (impls.length == 0 && ref instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyReference = (PsiPolyVariantReference)ref;
            text = polyReference.getRangeInElement().substring(polyReference.getElement().getText());
            ResolveResult[] results = polyReference.multiResolve(false);
            ArrayList<PsiElement> implsList = new ArrayList<PsiElement>(results.length);
            for (ResolveResult result : results) {
                PsiElement resolvedElement = result.getElement();
                if (resolvedElement == null || !resolvedElement.isPhysical()) continue;
                implsList.add(resolvedElement);
            }
            if (!implsList.isEmpty()) {
                impls = new PsiElement[implsList.size()];
                implsList.toArray(impls);
            }
        }
        this.showImplementations(impls, project, text, editor, file, isInvokedFromEditor);
    }

    protected void updateElementImplementations(PsiElement element, Editor editor, Project project, PsiFile file) {
        PsiElement[] impls = null;
        String text = "";
        if (element != null) {
            impls = ShowImplementationsAction.getSelfAndImplementations(editor, element);
            text = SymbolPresentationUtil.getSymbolPresentableText(element);
        }
        this.showImplementations(impls, project, text, editor, file, false);
    }

    protected void showImplementations(PsiElement[] impls, final Project project, String text, final Editor editor, final PsiFile file, boolean invokedFromEditor) {
        ImplementationViewComponent component;
        if (impls == null || impls.length == 0) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_FEATURE);
        if (LookupManager.getInstance(project).getActiveLookup() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE);
        }
        int index = 0;
        if (invokedFromEditor && file != null && impls.length > 1) {
            VirtualFile virtualFile = file.getVirtualFile();
            PsiFile containingFile = impls[0].getContainingFile();
            if (virtualFile != null && containingFile != null && virtualFile.equals(containingFile.getVirtualFile())) {
                index = 1;
            }
        }
        if ((component = new ImplementationViewComponent(impls, index)).hasElementsToShow()) {
            PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

                @Override
                public void updatePopup(Object lookupItemObject) {
                    PsiElement element = lookupItemObject instanceof PsiElement ? (PsiElement)lookupItemObject : DocumentationManager.getInstance(project).getElementFromLookup(editor, file);
                    ShowImplementationsAction.this.updateElementImplementations(element, editor, project, file);
                }
            };
            String title = CodeInsightBundle.message((String)"implementation.view.title", (Object[])new Object[]{text});
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPrefferedFocusableComponent()).setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setDimensionServiceKey(project, "ShowImplementationPopup", false).setResizable(true).setMovable(true).setTitle(title).createPopup();
            popup.showInBestPositionFor(DataManager.getInstance().getDataContext());
            component.setHint(popup, title);
        }
    }

    private static PsiElement[] getSelfAndImplementations(Editor editor, PsiElement element) {
        ImplementationSearcher handler = new ImplementationSearcher(){

            @Override
            protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements, int offset) {
                LinkedHashSet<PsiElement> unique = new LinkedHashSet<PsiElement>(Arrays.asList(targetElements));
                for (PsiElement elt : targetElements) {
                    PsiFile psiFile = elt.getContainingFile().getOriginalFile();
                    if (psiFile.getVirtualFile() != null) continue;
                    unique.remove(elt);
                }
                for (int i = 1; i < targetElements.length; ++i) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)targetElements[i], (PsiElement)targetElements[0], (boolean)true)) continue;
                    unique.remove(targetElements[0]);
                    break;
                }
                return unique.toArray(new PsiElement[unique.size()]);
            }
        };
        int offset = editor == null ? 0 : editor.getCaretModel().getOffset();
        PsiElement[] handlerImplementations = handler.searchImplementations(element, offset, !(element instanceof PomTargetPsiElement), true);
        if (handlerImplementations.length > 0) {
            return handlerImplementations;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null && (psiFile = (element = element.getNavigationElement()).getContainingFile()) == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiFile.getVirtualFile() != null && (element.getTextRange() != null || element instanceof PsiFile)) {
            return new PsiElement[]{element};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
    }
}

