/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import java.util.Map;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        editor.setHeaderComponent(null);
        if (project != null && ((HighlightManagerImpl)HighlightManager.getInstance((Project)project)).hideHighlights(editor, 3)) {
            WindowManager.getInstance().getStatusBar(project).setInfo("");
            FindManager findManager = FindManager.getInstance((Project)project);
            FindModel model = findManager.getFindNextModel(editor);
            if (model != null) {
                model.setSearchHighlighters(false);
                findManager.setFindNextModel(model);
            }
        } else {
            this.myOriginalHandler.execute(editor, dataContext);
        }
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        HighlightManagerImpl highlightManager;
        Map<RangeHighlighter, HighlightManagerImpl.HighlightInfo> map;
        if (editor.hasHeaderComponent()) {
            return true;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project != null && (map = (highlightManager = (HighlightManagerImpl)HighlightManager.getInstance((Project)project)).getHighlightInfoMap(editor, false)) != null) {
            for (HighlightManagerImpl.HighlightInfo info : map.values()) {
                if (!info.editor.equals(editor) || (info.flags & 1) == 0) continue;
                return true;
            }
        }
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }
}

