/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AutoIndentLinesHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.AutoIndentLinesHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int endOffset;
        int startOffset;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/AutoIndentLinesHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/AutoIndentLinesHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/AutoIndentLinesHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        Document document = editor.getDocument();
        RangeMarker selectionEndMarker = null;
        if (editor.getSelectionModel().hasSelection()) {
            startOffset = editor.getSelectionModel().getSelectionStart();
            endOffset = editor.getSelectionModel().getSelectionEnd();
            selectionEndMarker = document.createRangeMarker(endOffset, endOffset);
            --endOffset;
        } else {
            startOffset = endOffset = editor.getCaretModel().getOffset();
        }
        int line1 = editor.offsetToLogicalPosition((int)startOffset).line;
        int col = editor.getCaretModel().getLogicalPosition().column;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        try {
            if (startOffset == endOffset) {
                int lineStart = document.getLineStartOffset(line1);
                if (codeStyleManager.isLineToBeIndented(file, lineStart)) {
                    codeStyleManager.adjustLineIndent(file, lineStart);
                }
            } else {
                codeStyleManager.adjustLineIndent(file, new TextRange(startOffset, endOffset));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        if (selectionEndMarker == null) {
            if (line1 < document.getLineCount() - 1) {
                if (document.getLineStartOffset(line1 + 1) + col >= document.getTextLength()) {
                    col = document.getLineEndOffset(line1 + 1) - document.getLineStartOffset(line1 + 1);
                }
                LogicalPosition pos = new LogicalPosition(line1 + 1, col);
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getSelectionModel().removeSelection();
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        } else {
            if (!selectionEndMarker.isValid()) {
                return;
            }
            endOffset = selectionEndMarker.getEndOffset();
            editor.getSelectionModel().setSelection(startOffset, endOffset);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

