/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.FoldingUpdate");
    private static final Key<ParameterizedCachedValue<Runnable, Pair<Boolean, Boolean>>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement element, PsiElement element1) {
            int startOffsetDiff = element.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
            return startOffsetDiff == 0 ? element.getTextRange().getEndOffset() - element1.getTextRange().getEndOffset() : startOffsetDiff;
        }
    };
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(final @NotNull Editor editor, @NotNull PsiFile file, boolean applyDefaultState, boolean quick) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/FoldingUpdate.updateFoldRegions must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/FoldingUpdate.updateFoldRegions must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final Project project = file.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        ParameterizedCachedValue value = (ParameterizedCachedValue)editor.getUserData(CODE_FOLDING_KEY);
        if (value != null && value.hasUpToDateValue() && !applyDefaultState) {
            return null;
        }
        if (quick) {
            return (Runnable)FoldingUpdate.getUpdateResult(file, document, quick, project, editor, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, (ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Runnable, Pair<Boolean, Boolean>>(){

            public CachedValueProvider.Result<Runnable> compute(Pair<Boolean, Boolean> param) {
                Document document = editor.getDocument();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                return FoldingUpdate.getUpdateResult(file, document, (Boolean)param.first, project, editor, (Boolean)param.second);
            }
        }, false, (Object)Pair.create((Object)quick, (Object)applyDefaultState));
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(PsiFile file, Document document, boolean quick, Project project, final Editor editor, boolean applyDefaultState) {
        TreeMap<PsiElement, FoldingDescriptor> elementsToFoldMap = new TreeMap<PsiElement, FoldingDescriptor>(COMPARE_BY_OFFSET);
        FoldingUpdate.getFoldingsFor(file instanceof PsiCompiledElement ? (PsiFile)((PsiCompiledElement)file).getMirror() : file, document, elementsToFoldMap, quick);
        final UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project, editor, elementsToFoldMap, applyDefaultState, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Document> dependencies = new HashSet<Document>();
        dependencies.add(document);
        for (FoldingDescriptor descriptor : elementsToFoldMap.values()) {
            dependencies.addAll(descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create((Object)runnable, (Object[])ArrayUtil.toObjectArray(dependencies));
    }

    @Nullable
    public static Runnable updateInjectedFoldRegions(final @NotNull Editor editor, @NotNull PsiFile file, final boolean applyDefaultState) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/FoldingUpdate.updateInjectedFoldRegions must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/FoldingUpdate.updateInjectedFoldRegions must not be null");
        }
        if (file instanceof PsiCompiledElement) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final Project project = file.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        final long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        List<DocumentWindow> injectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(file);
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        final ArrayList<EditorWindow> injectedEditors = new ArrayList<EditorWindow>();
        final ArrayList<TreeMap<PsiElement, FoldingDescriptor>> maps = new ArrayList<TreeMap<PsiElement, FoldingDescriptor>>();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            Editor injectedEditor;
            PsiFile injectedFile = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)injectedDocument);
            if (injectedFile == null || !injectedFile.isValid() || !injectedDocument.isValid() || !((injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile)) instanceof EditorWindow)) continue;
            injectedEditors.add((EditorWindow)injectedEditor);
            TreeMap<PsiElement, FoldingDescriptor> map = new TreeMap<PsiElement, FoldingDescriptor>(COMPARE_BY_OFFSET);
            maps.add(map);
            FoldingUpdate.getFoldingsFor(injectedFile, (Document)injectedDocument, map, false);
        }
        return new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < injectedEditors.size(); ++i) {
                    EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                    if (!injectedEditor.getDocument().isValid()) continue;
                    Map map = (Map)maps.get(i);
                    UpdateFoldRegionsOperation op = new UpdateFoldRegionsOperation(project, injectedEditor, map, applyDefaultState, true);
                    editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)op);
                }
                editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
            }
        };
    }

    private static void getFoldingsFor(PsiFile file, Document document, Map<PsiElement, FoldingDescriptor> elementsToFoldMap, boolean quick) {
        FileViewProvider viewProvider = file.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psi = viewProvider.getPsi(language);
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (psi == null || foldingBuilder == null) continue;
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)quick)) {
                elementsToFoldMap.put(descriptor.getElement().getPsi(), descriptor);
            }
        }
    }
}

