/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;

public class SmartEnterAction
extends EditorAction {
    public SmartEnterAction() {
        super((EditorActionHandler)new Handler());
    }

    protected Editor getEditor(DataContext dataContext) {
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        }
        return project == null ? null : BaseCodeInsightAction.getInjectedEditor(project, editor);
    }

    public static void plainEnter(Editor editor, DataContext dataContext) {
        SmartEnterAction.getEnterHandler().execute(editor, dataContext);
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return SmartEnterAction.getEnterHandler().isEnabled(editor, dataContext);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            List processors;
            Document doc = editor.getDocument();
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (project == null || editor.isOneLineMode()) {
                SmartEnterAction.plainEnter(editor, dataContext);
                return;
            }
            int caretOffset = editor.getCaretModel().getOffset();
            if (Handler.isInPreceedingBlanks(editor)) {
                int caretLine = doc.getLineNumber(caretOffset);
                if (caretLine > 0) {
                    int prevLineEnd = doc.getLineEndOffset(caretLine - 1);
                    editor.getCaretModel().moveToOffset(prevLineEnd);
                }
                EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                enterHandler.execute(editor, dataContext);
                return;
            }
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (psiFile == null) {
                SmartEnterAction.plainEnter(editor, dataContext);
                return;
            }
            if (EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, caretOffset, psiFile.getFileType())) {
                EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                enterHandler.execute(editor, dataContext);
                return;
            }
            Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project);
            boolean processed = false;
            if (language != null && !(processors = SmartEnterProcessors.INSTANCE.forKey((Object)language)).isEmpty()) {
                for (SmartEnterProcessor processor : processors) {
                    if (!processor.process(project, editor, psiFile)) continue;
                    processed = true;
                    break;
                }
            }
            if (!processed) {
                SmartEnterAction.plainEnter(editor, dataContext);
            }
        }

        private static boolean isInPreceedingBlanks(Editor editor) {
            int offset = editor.getCaretModel().getOffset();
            Document doc = editor.getDocument();
            CharSequence chars = doc.getCharsSequence();
            if (offset == doc.getTextLength() || chars.charAt(offset) == '\n') {
                return false;
            }
            int newLineOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
            return newLineOffset < 0 || chars.charAt(newLineOffset) == '\n';
        }
    }
}

