/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nullable;

public class EnterHandler
extends BaseEnterHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.EnterHandler");
    private final EditorActionHandler myOriginalHandler;

    public EnterHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }

    public void executeWriteAction(final Editor editor, final DataContext dataContext) {
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            PostprocessReformattingAspect.getInstance(project).disablePostprocessFormattingInside(new Runnable(){

                @Override
                public void run() {
                    EnterHandler.this.executeWriteActionInner(editor, dataContext, project);
                }
            });
        } else {
            this.executeWriteActionInner(editor, dataContext, project);
        }
    }

    private void executeWriteActionInner(Editor editor, DataContext dataContext, Project project) {
        int offset1;
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (project == null) {
            this.myOriginalHandler.execute(editor, dataContext);
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            this.myOriginalHandler.execute(editor, dataContext);
            return;
        }
        CommandProcessor.getInstance().setCurrentCommandName(CodeInsightBundle.message((String)"command.name.typing", (Object[])new Object[0]));
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text = document.getCharsSequence();
        int length = document.getTextLength();
        if (caretOffset < length && text.charAt(caretOffset) != '\n' && ((offset1 = CharArrayUtil.shiftBackward((CharSequence)text, (int)caretOffset, (String)" \t")) < 0 || text.charAt(offset1) == '\n')) {
            boolean isEmptyLine;
            int offset2 = CharArrayUtil.shiftForward((CharSequence)text, (int)(offset1 + 1), (String)" \t");
            boolean bl = isEmptyLine = offset2 >= length || text.charAt(offset2) == '\n';
            if (!isEmptyLine) {
                this.myOriginalHandler.execute(editor, dataContext);
                return;
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        boolean forceIndent = false;
        Ref caretOffsetRef = new Ref((Object)caretOffset);
        Ref caretAdvanceRef = new Ref((Object)0);
        for (EnterHandlerDelegate delegate : (EnterHandlerDelegate[])Extensions.getExtensions(EnterHandlerDelegate.EP_NAME)) {
            EnterHandlerDelegate.Result result = delegate.preprocessEnter(file, editor, (Ref<Integer>)caretOffsetRef, (Ref<Integer>)caretAdvanceRef, dataContext, this.myOriginalHandler);
            if (result == EnterHandlerDelegate.Result.Stop) {
                return;
            }
            if (result == EnterHandlerDelegate.Result.Continue) continue;
            text = document.getCharsSequence();
            if (result != EnterHandlerDelegate.Result.DefaultForceIndent) break;
            forceIndent = true;
            break;
        }
        boolean isFirstColumn = (caretOffset = ((Integer)caretOffsetRef.get()).intValue()) == 0 || text.charAt(caretOffset - 1) == '\n';
        boolean insertSpace = !isFirstColumn && caretOffset < document.getTextLength() && text.charAt(caretOffset) != ' ' && text.charAt(caretOffset) != '\t';
        editor.getCaretModel().moveToOffset(caretOffset);
        this.myOriginalHandler.execute(editor, dataContext);
        if (settings.SMART_INDENT_ON_ENTER || forceIndent) {
            ++caretOffset;
            caretOffset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)caretOffset, (String)" \t");
        } else {
            caretOffset = editor.getCaretModel().getOffset();
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DoEnterAction action = new DoEnterAction(file, editor, document, caretOffset, !insertSpace, (Integer)caretAdvanceRef.get());
        action.setForceIndent(forceIndent);
        action.run();
    }

    private static boolean isCommentComplete(PsiComment comment, CodeDocumentationAwareCommenter commenter) {
        JavaLikeQuoteHandler javaLikeQuoteHandler;
        String expectedCommentEnd;
        String commentText = comment.getText();
        String string = expectedCommentEnd = EnterHandler.isDocComment((PsiElement)comment, commenter) ? commenter.getDocumentationCommentSuffix() : commenter.getBlockCommentSuffix();
        if (!commentText.endsWith(expectedCommentEnd)) {
            return false;
        }
        PsiFile containingFile = comment.getContainingFile();
        Language language = comment.getParent().getLanguage();
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).createLexer(containingFile.getProject());
        lexer.start((CharSequence)commentText, commenter.getDocumentationCommentPrefix().length(), commentText.length());
        QuoteHandler fileTypeHandler = TypedHandler.getQuoteHandler(containingFile);
        JavaLikeQuoteHandler javaLikeQuoteHandler2 = javaLikeQuoteHandler = fileTypeHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeHandler : null;
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (javaLikeQuoteHandler != null && javaLikeQuoteHandler.getStringTokenTypes() != null && javaLikeQuoteHandler.getStringTokenTypes().contains(tokenType)) {
                String text = commentText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                int endOffset = comment.getTextRange().getEndOffset();
                if (text.endsWith(expectedCommentEnd) && endOffset < containingFile.getTextLength() && containingFile.getText().charAt(endOffset) == '\n') {
                    return true;
                }
            }
            if (lexer.getTokenEnd() == commentText.length()) {
                if (lexer.getTokenType() == commenter.getLineCommentTokenType()) {
                    lexer.start((CharSequence)commentText, lexer.getTokenStart() + commenter.getLineCommentPrefix().length(), commentText.length());
                    lexer.advance();
                    continue;
                }
                return lexer.getTokenEnd() - lexer.getTokenStart() == 1;
            }
            if (tokenType == commenter.getDocumentationCommentTokenType() || tokenType == commenter.getBlockCommentTokenType()) {
                return false;
            }
            lexer.advance();
        }
        return false;
    }

    private static boolean isDocComment(PsiElement element, CodeDocumentationAwareCommenter commenter) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        return commenter.isDocumentationComment(comment);
    }

    private static class DoEnterAction
    implements Runnable {
        private final PsiFile myFile;
        private int myOffset;
        private final Document myDocument;
        private final boolean myInsertSpace;
        private final Editor myEditor;
        private int myCaretAdvance;
        private boolean myForceIndent = false;
        private static final String LINE_SEPARATOR = "\n";

        public DoEnterAction(PsiFile file, Editor view, Document document, int offset, boolean insertSpace, int caretAdvance) {
            this.myEditor = view;
            this.myFile = file;
            this.myOffset = offset;
            this.myDocument = document;
            this.myInsertSpace = insertSpace;
            this.myCaretAdvance = caretAdvance;
        }

        public void setForceIndent(boolean forceIndent) {
            this.myForceIndent = forceIndent;
        }

        @Override
        public void run() {
            try {
                PsiElement element;
                boolean slashSlash;
                CharSequence chars = this.myDocument.getCharsSequence();
                int offset = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(this.myOffset - 1), (String)LINE_SEPARATOR) - 1;
                offset = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)offset, (String)LINE_SEPARATOR) + 1;
                if (offset < 0) {
                    offset = 0;
                }
                int lineStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
                Commenter langCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(PsiUtilBase.getLanguageAtOffset((PsiFile)this.myFile, (int)offset));
                boolean isInsideJavalikeCode = langCommenter instanceof CodeDocumentationAwareCommenter;
                CodeDocumentationAwareCommenter commenter = isInsideJavalikeCode ? (CodeDocumentationAwareCommenter)langCommenter : null;
                boolean docStart = isInsideJavalikeCode && commenter.getDocumentationCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)commenter.getDocumentationCommentPrefix());
                boolean cStyleStart = isInsideJavalikeCode && commenter.getBlockCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)commenter.getBlockCommentPrefix());
                boolean docAsterisk = isInsideJavalikeCode && commenter.getDocumentationCommentLinePrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)commenter.getDocumentationCommentLinePrefix());
                int firstNonSpaceInLine = CharArrayUtil.shiftForward((CharSequence)chars, (int)this.myOffset, (String)" \t");
                boolean bl = slashSlash = isInsideJavalikeCode && commenter.getLineCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)commenter.getLineCommentPrefix()) && firstNonSpaceInLine < chars.length() && chars.charAt(firstNonSpaceInLine) != '\n';
                if (docStart) {
                    element = this.myFile.findElementAt(lineStart);
                    String text = element.getText();
                    PsiElement parent = element.getParent();
                    if (text.equals(commenter.getDocumentationCommentPrefix()) && EnterHandler.isDocComment(parent, commenter) || text.startsWith(commenter.getDocumentationCommentPrefix()) && element instanceof PsiComment) {
                        PsiComment comment = EnterHandler.isDocComment(parent, commenter) ? (PsiComment)parent : (PsiComment)element;
                        int commentEnd = comment.getTextRange().getEndOffset();
                        if (this.myOffset >= commentEnd) {
                            docStart = false;
                        } else if (EnterHandler.isCommentComplete(comment, commenter)) {
                            if (this.myOffset >= commentEnd) {
                                docAsterisk = false;
                                docStart = false;
                            } else {
                                docAsterisk = true;
                                docStart = false;
                            }
                        } else {
                            this.generateJavadoc(commenter);
                        }
                    } else {
                        docStart = false;
                    }
                } else if (cStyleStart) {
                    element = this.myFile.findElementAt(lineStart);
                    if (element instanceof PsiComment && commenter.getBlockCommentTokenType() == ((PsiComment)element).getTokenType()) {
                        PsiComment comment = (PsiComment)element;
                        int commentEnd = comment.getTextRange().getEndOffset();
                        if (this.myOffset >= commentEnd) {
                            docStart = false;
                        } else if (EnterHandler.isCommentComplete(comment, commenter)) {
                            if (this.myOffset >= commentEnd) {
                                docAsterisk = false;
                                docStart = false;
                            } else {
                                docAsterisk = true;
                                docStart = false;
                            }
                        } else {
                            int currentEndOfLine = CharArrayUtil.shiftForwardUntil((CharSequence)chars, (int)this.myOffset, (String)LINE_SEPARATOR);
                            this.myDocument.insertString(currentEndOfLine, (CharSequence)(" " + commenter.getBlockCommentSuffix()));
                            int lstart = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)this.myOffset, (String)LINE_SEPARATOR);
                            this.myDocument.insertString(currentEndOfLine, chars.subSequence(lstart, this.myOffset));
                        }
                    } else {
                        docStart = false;
                    }
                }
                if (docAsterisk) {
                    docAsterisk = this.insertDocAsterisk(lineStart, docAsterisk, commenter);
                }
                if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER || this.myForceIndent || docStart || docAsterisk || slashSlash) {
                    this.myOffset = CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(this.myFile, this.myOffset);
                }
                if (docAsterisk || docStart || slashSlash) {
                    char c;
                    if (this.myInsertSpace) {
                        if (this.myOffset == this.myDocument.getTextLength()) {
                            this.myDocument.insertString(this.myOffset, (CharSequence)" ");
                        }
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)" ");
                    }
                    if ((c = this.myDocument.getCharsSequence().charAt(this.myOffset)) != '\n') {
                        ++this.myOffset;
                    }
                }
                if ((docAsterisk || slashSlash) && !docStart) {
                    this.myCaretAdvance = slashSlash ? commenter.getLineCommentPrefix().length() : 1;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            this.myEditor.getCaretModel().moveToOffset(this.myOffset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
            if (this.myCaretAdvance != 0) {
                LogicalPosition caretPosition = this.myEditor.getCaretModel().getLogicalPosition();
                LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + this.myCaretAdvance);
                this.myEditor.getCaretModel().moveToLogicalPosition(pos);
            }
        }

        private void generateJavadoc(CodeDocumentationAwareCommenter commenter) throws IncorrectOperationException {
            CodeInsightSettings settings = CodeInsightSettings.getInstance();
            StringBuffer buffer = new StringBuffer();
            String docCommentLinePrefix = commenter.getDocumentationCommentLinePrefix();
            if (docCommentLinePrefix == null) {
                return;
            }
            buffer.append(docCommentLinePrefix);
            buffer.append(LINE_SEPARATOR);
            buffer.append(commenter.getDocumentationCommentSuffix());
            PsiComment comment = this.createComment(buffer, settings);
            if (comment == null) {
                return;
            }
            this.myOffset = comment.getTextRange().getStartOffset();
            this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
            DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
            if (!CodeStyleSettingsManager.getSettings((Project)this.getProject()).JD_LEADING_ASTERISKS_ARE_ENABLED) {
                LOG.assertTrue(CharArrayUtil.regionMatches((CharSequence)this.myDocument.getCharsSequence(), (int)(this.myOffset - docCommentLinePrefix.length()), (CharSequence)docCommentLinePrefix));
                this.myDocument.deleteString(this.myOffset - docCommentLinePrefix.length(), this.myOffset);
                --this.myOffset;
            } else {
                this.myDocument.insertString(this.myOffset, (CharSequence)" ");
                ++this.myOffset;
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private PsiComment createComment(StringBuffer buffer, CodeInsightSettings settings) throws IncorrectOperationException {
            this.myDocument.insertString(this.myOffset, (CharSequence)buffer.toString());
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(this.myFile, this.myOffset + buffer.length() - 2);
            PsiComment comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            comment = this.createJavaDocStub(settings, comment, this.getProject());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.getProject());
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.getProject());
            boolean old = codeStyleSettings.ENABLE_JAVADOC_FORMATTING;
            codeStyleSettings.ENABLE_JAVADOC_FORMATTING = false;
            try {
                comment = (PsiComment)codeStyleManager.reformat((PsiElement)comment);
            }
            finally {
                codeStyleSettings.ENABLE_JAVADOC_FORMATTING = old;
            }
            PsiElement next = comment.getNextSibling();
            if (next == null && comment.getParent().getClass() == comment.getClass()) {
                next = comment.getParent().getNextSibling();
            }
            if (!(next instanceof PsiWhiteSpace) || !next.getText().contains(LINE_SEPARATOR)) {
                int lineBreakOffset = comment.getTextRange().getEndOffset();
                this.myDocument.insertString(lineBreakOffset, (CharSequence)LINE_SEPARATOR);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                codeStyleManager.adjustLineIndent(this.myFile, lineBreakOffset + 1);
                comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            }
            return comment;
        }

        private PsiComment createJavaDocStub(CodeInsightSettings settings, PsiComment comment, Project project) {
            if (settings.JAVADOC_STUB_ON_ENTER) {
                CodeDocumentationProvider docProvider;
                DocumentationProvider langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(comment.getParent().getLanguage());
                if (langDocumentationProvider instanceof CompositeDocumentationProvider) {
                    docProvider = ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider();
                } else {
                    CodeDocumentationProvider codeDocumentationProvider = docProvider = langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null;
                }
                if (docProvider != null) {
                    if (docProvider.findExistingDocComment(comment) != comment) {
                        return comment;
                    }
                    String docStub = docProvider.generateDocumentationContentStub(comment);
                    if (docStub != null && docStub.length() != 0) {
                        this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
                        this.myOffset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
                        this.myDocument.insertString(this.myOffset, (CharSequence)docStub);
                    }
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                return (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            }
            return comment;
        }

        private Project getProject() {
            return this.myFile.getProject();
        }

        private static void removeTrailingSpaces(Document document, int startOffset) {
            int endOffset = startOffset;
            CharSequence charsSequence = document.getCharsSequence();
            for (int i = startOffset; i < charsSequence.length(); ++i) {
                char c = charsSequence.charAt(i);
                endOffset = i;
                if (c == '\n') break;
                if (c == ' ' || c == '\t') continue;
                return;
            }
            document.deleteString(startOffset, endOffset);
        }

        private boolean insertDocAsterisk(int lineStart, boolean docAsterisk, CodeDocumentationAwareCommenter commenter) {
            PsiElement atLineStart = this.myFile.findElementAt(lineStart);
            if (atLineStart == null) {
                return false;
            }
            String documentationCommentLinePrefix = commenter.getDocumentationCommentLinePrefix();
            String docommentPrefix = commenter.getDocumentationCommentPrefix();
            String text = atLineStart.getText();
            TextRange textRange = atLineStart.getTextRange();
            if (text.equals(documentationCommentLinePrefix) || text.equals(docommentPrefix) || text.regionMatches(lineStart - textRange.getStartOffset(), docommentPrefix, 0, docommentPrefix.length()) || text.regionMatches(lineStart - textRange.getStartOffset(), documentationCommentLinePrefix, 0, documentationCommentLinePrefix.length())) {
                PsiComment comment;
                PsiElement element = this.myFile.findElementAt(this.myOffset);
                if (element == null) {
                    return false;
                }
                PsiComment psiComment = comment = element instanceof PsiComment ? (PsiComment)element : (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
                if (comment != null) {
                    int commentEnd = comment.getTextRange().getEndOffset();
                    if (this.myOffset >= commentEnd) {
                        docAsterisk = false;
                    } else {
                        DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
                        this.myDocument.insertString(this.myOffset, (CharSequence)CodeDocumentationUtil.createDocCommentLine("", this.getProject(), commenter));
                        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                    }
                } else {
                    docAsterisk = false;
                }
            } else if (atLineStart instanceof PsiComment && ((PsiComment)atLineStart).getTokenType() == commenter.getBlockCommentTokenType()) {
                int nextLineOffset;
                boolean usesAstersk = false;
                int commentLine = this.myDocument.getLineNumber(textRange.getStartOffset());
                if (commentLine < this.myDocument.getLineCount() - 1 && textRange.getEndOffset() >= this.myOffset && (nextLineOffset = this.myDocument.getLineStartOffset(commentLine + 1)) < textRange.getEndOffset()) {
                    CharSequence chars = this.myDocument.getCharsSequence();
                    nextLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)nextLineOffset, (String)" \t");
                    usesAstersk = CharArrayUtil.regionMatches((CharSequence)chars, (int)nextLineOffset, (CharSequence)documentationCommentLinePrefix);
                }
                if (usesAstersk) {
                    DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
                    this.myDocument.insertString(this.myOffset, (CharSequence)(documentationCommentLinePrefix + " "));
                    PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                }
                docAsterisk = usesAstersk;
            } else {
                docAsterisk = false;
            }
            return docAsterisk;
        }
    }
}

