/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.ReferenceTransferableData;
import com.intellij.codeInsight.editorActions.RestoreReferencesDialog;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CopyPasteReferenceProcessor
implements CopyPastePostProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.CopyPasteReferenceProcessor");

    @Override
    public TextBlockTransferableData collectTransferableData(PsiFile file, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (file instanceof PsiCompiledElement) {
            file = (PsiFile)((PsiCompiledElement)file).getMirror();
        }
        if (!(file instanceof PsiClassOwner)) {
            return new ReferenceTransferableData(new ReferenceTransferableData.ReferenceData[0]);
        }
        ArrayList<ReferenceTransferableData.ReferenceData> array = new ArrayList<ReferenceTransferableData.ReferenceData>();
        for (int j = 0; j < startOffsets.length; ++j) {
            int startOffset = startOffsets[j];
            int endOffset = endOffsets[j];
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file, startOffset, endOffset);
            for (PsiElement element : elements) {
                JavaResolveResult resolveResult;
                PsiElement refElement;
                if (!(element instanceof PsiJavaCodeReferenceElement) || ((PsiJavaCodeReferenceElement)element).isQualified() || (refElement = (resolveResult = ((PsiJavaCodeReferenceElement)element).advancedResolve(false)).getElement()) == null || refElement.getContainingFile() == file) continue;
                if (refElement instanceof PsiClass) {
                    String qName;
                    if (refElement.getContainingFile() == element.getContainingFile() || (qName = ((PsiClass)refElement).getQualifiedName()) == null) continue;
                    CopyPasteReferenceProcessor.addReferenceData(element, array, startOffset, qName, null);
                    continue;
                }
                if (!(resolveResult.getCurrentFileResolveScope() instanceof PsiImportStaticStatement)) continue;
                String classQName = ((PsiMember)refElement).getContainingClass().getQualifiedName();
                String name = ((PsiNamedElement)refElement).getName();
                if (classQName == null || name == null) continue;
                CopyPasteReferenceProcessor.addReferenceData(element, array, startOffset, classQName, name);
            }
        }
        return new ReferenceTransferableData(array.toArray(new ReferenceTransferableData.ReferenceData[array.size()]));
    }

    @Override
    @Nullable
    public TextBlockTransferableData extractTransferableData(Transferable content) {
        ReferenceTransferableData referenceData = null;
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE != 2) {
            try {
                DataFlavor flavor = ReferenceTransferableData.ReferenceData.getDataFlavor();
                if (flavor != null) {
                    referenceData = (ReferenceTransferableData)content.getTransferData(flavor);
                }
            }
            catch (UnsupportedFlavorException ignored) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (referenceData != null) {
            return referenceData.clone();
        }
        return null;
    }

    @Override
    public void processTransferableData(Project project, Editor editor, RangeMarker bounds, TextBlockTransferableData value) {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!(file instanceof PsiClassOwner)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final ReferenceTransferableData.ReferenceData[] referenceData = ((ReferenceTransferableData)value).getData();
        final PsiJavaCodeReferenceElement[] refs = CopyPasteReferenceProcessor.findReferencesToRestore(file, bounds, referenceData);
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 3) {
            CopyPasteReferenceProcessor.askReferencesToRestore(project, refs, referenceData);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CopyPasteReferenceProcessor.restoreReferences(referenceData, refs);
            }
        });
    }

    private static void addReferenceData(PsiElement element, ArrayList<ReferenceTransferableData.ReferenceData> array, int startOffset, String qClassName, String staticMemberName) {
        TextRange range = element.getTextRange();
        array.add(new ReferenceTransferableData.ReferenceData(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, qClassName, staticMemberName));
    }

    private static PsiJavaCodeReferenceElement[] findReferencesToRestore(PsiFile file, RangeMarker bounds, ReferenceTransferableData.ReferenceData[] referenceData) {
        PsiManager manager = file.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper helper = facade.getResolveHelper();
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[referenceData.length];
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement referent;
            PsiJavaCodeReferenceElement reference;
            TextRange range;
            ReferenceTransferableData.ReferenceData data = referenceData[i];
            PsiClass refClass = facade.findClass(data.qClassName, file.getResolveScope());
            if (refClass == null) continue;
            int startOffset = data.startOffset + bounds.getStartOffset();
            int endOffset = data.endOffset + bounds.getStartOffset();
            PsiElement element = file.findElementAt(startOffset);
            if (!(element instanceof PsiIdentifier) || !(element.getParent() instanceof PsiJavaCodeReferenceElement) || (range = (reference = (PsiJavaCodeReferenceElement)element.getParent()).getTextRange()).getStartOffset() != startOffset || range.getEndOffset() != endOffset) continue;
            if (data.staticMemberName == null) {
                PsiClass refClass1 = helper.resolveReferencedClass(reference.getText(), (PsiElement)reference);
                if (refClass1 != null && manager.areElementsEquivalent((PsiElement)refClass, (PsiElement)refClass1)) continue;
                refs[i] = reference;
                continue;
            }
            if (!(reference instanceof PsiReferenceExpression) || (referent = reference.resolve()) instanceof PsiNamedElement && data.staticMemberName.equals(((PsiNamedElement)referent).getName()) && referent instanceof PsiMember && ((PsiMember)referent).getContainingClass() != null && data.qClassName.equals(((PsiMember)referent).getContainingClass().getQualifiedName())) continue;
            refs[i] = reference;
        }
        return refs;
    }

    private static void restoreReferences(ReferenceTransferableData.ReferenceData[] referenceData, PsiJavaCodeReferenceElement[] refs) {
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement reference = refs[i];
            if (reference == null) continue;
            try {
                PsiManager manager = reference.getManager();
                ReferenceTransferableData.ReferenceData refData = referenceData[i];
                PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(refData.qClassName, reference.getResolveScope());
                if (refClass == null) continue;
                if (refData.staticMemberName == null) {
                    reference.bindToElement((PsiElement)refClass);
                    continue;
                }
                LOG.assertTrue(reference instanceof PsiReferenceExpression);
                ((PsiReferenceExpression)reference).bindToElementViaStaticImport(refClass);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void askReferencesToRestore(Project project, PsiJavaCodeReferenceElement[] refs, ReferenceTransferableData.ReferenceData[] referenceData) {
        Object refObject;
        PsiManager manager = PsiManager.getInstance((Project)project);
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        Object[] refObjects = new Object[refs.length];
        for (int i = 0; i < referenceData.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (ref == null) continue;
            LOG.assertTrue(ref.isValid());
            ReferenceTransferableData.ReferenceData data = referenceData[i];
            PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(data.qClassName, ref.getResolveScope());
            if (refClass == null) continue;
            refObject = refClass;
            if (data.staticMemberName != null) {
                refObject = refClass.getQualifiedName() + "." + data.staticMemberName;
            }
            refObjects[i] = refObject;
            if (array.contains(refObject)) continue;
            array.add((PsiClass)refObject);
        }
        if (array.isEmpty()) {
            return;
        }
        Object[] selectedObjects = ArrayUtil.toObjectArray(array);
        Arrays.sort(selectedObjects, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String fqName1 = CopyPasteReferenceProcessor.getFQName(o1);
                String fqName2 = CopyPasteReferenceProcessor.getFQName(o2);
                return fqName1.compareToIgnoreCase(fqName2);
            }
        });
        RestoreReferencesDialog dialog = new RestoreReferencesDialog(project, selectedObjects);
        dialog.show();
        selectedObjects = dialog.getSelectedElements();
        for (int i = 0; i < referenceData.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (ref == null) continue;
            LOG.assertTrue(ref.isValid());
            refObject = refObjects[i];
            boolean found = false;
            for (Object selected : selectedObjects) {
                if (!refObject.equals(selected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            refs[i] = null;
        }
    }

    private static String getFQName(Object element) {
        return element instanceof PsiClass ? ((PsiClass)element).getQualifiedName() : (String)element;
    }
}

