/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class SetupJDKFix
implements IntentionAction {
    private static final SetupJDKFix ourInstance = new SetupJDKFix();

    public static SetupJDKFix getInstnace() {
        return ourInstance;
    }

    private SetupJDKFix() {
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("setup.jdk.location.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SetupJDKFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("setup.jdk.location.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SetupJDKFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SetupJDKFix.isAvailable must not be null");
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", file.getResolveScope()) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, final PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SetupJDKFix.invoke must not be null");
        }
        Sdk projectJdk = ProjectSettingsService.getInstance(project).chooseAndSetSdk();
        if (projectJdk == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
                if (module != null) {
                    ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    modifiableModel.inheritSdk();
                    modifiableModel.commit();
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

