/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.XmlSettings;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.analysis.ImportNSAction;
import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNSDeclarationIntentionFix
implements HintAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix");
    private final String myNamespacePrefix;
    private final PsiElement myElement;
    private final XmlFile myFile;
    private final XmlToken myToken;

    public CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.<init> must not be null");
        }
        if (namespacePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.<init> must not be null");
        }
        this(element, namespacePrefix, null);
    }

    public CreateNSDeclarationIntentionFix(PsiElement element, String namespacePrefix, XmlToken token) {
        this.myNamespacePrefix = namespacePrefix;
        this.myElement = element;
        this.myFile = (XmlFile)element.getContainingFile();
        this.myToken = token;
    }

    @NotNull
    public String getText() {
        String alias = StringUtil.capitalize((String)XmlExtension.getExtension((PsiFile)this.myFile).getNamespaceAlias(this.myFile));
        String string = XmlErrorMessages.message("create.namespace.declaration.quickfix", alias);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.applyFix must not be null");
        }
        PsiFile containingFile = descriptor.getPsiElement().getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        PsiFile psiFile = file = editor != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) : null;
        if (file == null || file.getVirtualFile() != containingFile.getVirtualFile()) {
            return;
        }
        try {
            this.invoke(project, editor, containingFile);
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.isAvailable must not be null");
        }
        return this.myElement.isValid();
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.invoke must not be null");
        }
        if (!this.myElement.isValid() || !CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        Set<String> set = XmlExtension.getExtension(file).guessUnboundNamespaces(this.myElement, (XmlFile)file);
        Object[] namespaces = ArrayUtil.toStringArray(set);
        Arrays.sort(namespaces);
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne((String[])namespaces, project, new StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(final @NotNull String namespace) throws IncorrectOperationException {
                if (namespace == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix$1.doSomethingWithGivenStringToProduceXmlAttributeNowPlease must not be null");
                }
                String prefix = CreateNSDeclarationIntentionFix.this.myNamespacePrefix;
                if (StringUtil.isEmpty((String)prefix)) {
                    XmlExtension extension = XmlExtension.getExtension((PsiFile)CreateNSDeclarationIntentionFix.this.myFile);
                    XmlFile xmlFile = extension.getContainingFile(CreateNSDeclarationIntentionFix.this.myElement);
                    prefix = ExtendedTagInsertHandler.getPrefixByNamespace(xmlFile, namespace);
                    if (StringUtil.isNotEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, CreateNSDeclarationIntentionFix.this.myElement);
                        return;
                    }
                    prefix = ExtendedTagInsertHandler.suggestPrefix(xmlFile, namespace);
                    if (StringUtil.isNotEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, CreateNSDeclarationIntentionFix.this.myElement);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    }
                }
                int offset = editor.getCaretModel().getOffset();
                final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
                XmlExtension extension = XmlExtension.getExtension(file);
                extension.insertNamespaceDeclaration((XmlFile)file, editor, Collections.singleton(namespace), prefix, new XmlExtension.Runner<String, IncorrectOperationException>(){

                    @Override
                    public void run(String param) throws IncorrectOperationException {
                        if (namespace.length() > 0) {
                            editor.getCaretModel().moveToOffset(marker.getStartOffset());
                        }
                    }
                });
            }
        }, this.getTitle(), (IntentionAction)this, editor);
    }

    private String getTitle() {
        return XmlErrorMessages.message("select.namespace.title", StringUtil.capitalize((String)XmlExtension.getExtension((PsiFile)this.myFile).getNamespaceAlias(this.myFile)));
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean showHint(Editor editor) {
        if (!XmlSettings.getInstance().SHOW_XML_ADD_IMPORT_HINTS || !this.myElement.isValid() || this.myNamespacePrefix.length() == 0) {
            return false;
        }
        Set<String> namespaces = XmlExtension.getExtension((PsiFile)this.myFile).guessUnboundNamespaces(this.myElement, this.myFile);
        if (!namespaces.isEmpty()) {
            String message = ShowAutoImportPass.getMessage(namespaces.size() > 1, namespaces.iterator().next());
            String title = this.getTitle();
            ImportNSAction action = new ImportNSAction(namespaces, this.myFile, this.myElement, editor, title);
            if (this.myElement instanceof XmlTag) {
                if (ShowAutoImportPass.getVisibleRange(editor).contains(this.myToken.getTextRange())) {
                    HintManager.getInstance().showQuestionHint(editor, message, this.myToken.getTextOffset(), this.myToken.getTextOffset() + this.myNamespacePrefix.length(), (QuestionAction)action);
                    return true;
                }
            } else {
                HintManager.getInstance().showQuestionHint(editor, message, this.myElement.getTextOffset(), this.myElement.getTextRange().getEndOffset(), (QuestionAction)action);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfGivenXmlHasTheseWords(String name, XmlFile tldFileByUri) {
        if (name == null || name.length() == 0) {
            return true;
        }
        List list = StringUtil.getWordsIn((String)name);
        final String[] words = ArrayUtil.toStringArray((Collection)list);
        final boolean[] wordsFound = new boolean[words.length];
        final int[] wordsFoundCount = new int[1];
        IdTableBuilding.ScanWordProcessor wordProcessor = new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, int start, int end) {
                if (wordsFoundCount[0] == words.length) {
                    return;
                }
                int foundWordLen = end - start;
                block0: for (int i = 0; i < words.length; ++i) {
                    String localName = words[i];
                    if (wordsFound[i] || localName.length() != foundWordLen) continue;
                    for (int j = 0; j < localName.length(); ++j) {
                        if (chars.charAt(start + j) != localName.charAt(j)) continue block0;
                    }
                    wordsFound[i] = true;
                    wordsFoundCount[0] = wordsFoundCount[0] + 1;
                    break;
                }
            }
        };
        CharSequence contents = tldFileByUri.getViewProvider().getContents();
        IdTableBuilding.scanWords(wordProcessor, contents, 0, contents.length());
        return wordsFoundCount[0] == words.length;
    }

    public static void runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(final @NotNull String[] namespacesToChooseFrom, final Project project, final StringToAttributeProcessor onSelection, String title, final IntentionAction requestor, Editor editor) throws IncorrectOperationException {
        if (namespacesToChooseFrom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne must not be null");
        }
        if (namespacesToChooseFrom.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            final JList<String> list = new JList<String>(namespacesToChooseFrom);
            list.setCellRenderer((ListCellRenderer<String>)((Object)XmlNSRenderer.INSTANCE));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    final int index = list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(namespacesToChooseFrom[index]);
                                    }
                                    catch (IncorrectOperationException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                            });
                        }
                    }, requestor.getText(), (Object)requestor.getFamilyName());
                }
            };
            new PopupChooserBuilder(list).setTitle(title).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
        } else {
            onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(namespacesToChooseFrom.length == 0 ? "" : namespacesToChooseFrom[0]);
        }
    }

    public static void processExternalUris(final MetaHandler metaHandler, final PsiFile file, final ExternalUriProcessor processor, boolean showProgress) {
        if (!showProgress || ApplicationManager.getApplication().isUnitTestMode()) {
            CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file, processor);
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file, processor);
                }
            }, XmlErrorMessages.message("finding.acceptable.uri", new Object[0]), false, file.getProject());
        }
    }

    private static void processExternalUrisImpl(MetaHandler metaHandler, PsiFile file, ExternalUriProcessor processor) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        String searchFor = metaHandler.searchFor();
        if (pi != null) {
            pi.setText(XmlErrorMessages.message("looking.in.schemas", new Object[0]));
        }
        ExternalResourceManager instanceEx = ExternalResourceManager.getInstance();
        String[] availableUrls = instanceEx.getResourceUrls(null, true);
        int i = 0;
        for (String url : availableUrls) {
            String defaultNamespace;
            boolean wordFound;
            XmlFile xmlFile;
            if (pi != null) {
                pi.setFraction((double)i / (double)availableUrls.length);
                pi.setText2(url);
                ++i;
            }
            if ((xmlFile = XmlUtil.findNamespace(file, url)) == null || !(wordFound = CreateNSDeclarationIntentionFix.checkIfGivenXmlHasTheseWords(searchFor, xmlFile))) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            PsiMetaData metaData = document.getMetaData();
            if (!metaHandler.isAcceptableMetaData(metaData, url)) continue;
            XmlNSDescriptorImpl descriptor = metaData instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)metaData : null;
            String string = defaultNamespace = descriptor != null ? descriptor.getDefaultNamespace() : url;
            if ("http://www.w3.org/1999/XMLSchema".equals(defaultNamespace) || "http://www.w3.org/2000/10/XMLSchema".equals(defaultNamespace)) continue;
            processor.process(defaultNamespace, url);
        }
    }

    public static interface ExternalUriProcessor {
        public void process(@NotNull String var1, @Nullable String var2);
    }

    public static class TagMetaHandler
    implements MetaHandler {
        private final String myName;

        public TagMetaHandler(String name) {
            this.myName = name;
        }

        @Override
        public boolean isAcceptableMetaData(PsiMetaData metaData, String url) {
            if (metaData instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
                XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(this.searchFor(), url);
                return descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor);
            }
            return false;
        }

        @Override
        public String searchFor() {
            return this.myName;
        }
    }

    public static interface MetaHandler {
        public boolean isAcceptableMetaData(PsiMetaData var1, String var2);

        public String searchFor();
    }

    public static interface StringToAttributeProcessor {
        public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NonNls @NotNull String var1) throws IncorrectOperationException;
    }
}

