/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UpdateHighlightersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create((String)"FILE_LEVEL_HIGHLIGHTS");
    private static final Comparator<TextRange> BY_START_OFFSET = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };
    private static final Comparator<TextRange> BY_START_OFFSET_OR_CONTAINS = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            if (o1.contains(o2) || o2.contains(o1)) {
                return 0;
            }
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create((String)"TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static void cleanFileLevelHighlights(@NotNull Project project, int group, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.cleanFileLevelHighlights must not be null");
        }
        if (psiFile == null || !psiFile.getViewProvider().isPhysical()) {
            return;
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : infos) {
                if (info.group != group) continue;
                manager.removeEditorAnnotation(fileEditor, info.fileLevelComponent);
                infosToRemove.add(info);
            }
            infos.removeAll(infosToRemove);
        }
    }

    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, int group) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setHighlightersToEditor must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setHighlightersToEditor must not be null");
        }
        if (highlights == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setHighlightersToEditor must not be null");
        }
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, Collections.singletonMap(new TextRange(startOffset, endOffset), highlights), group);
    }

    static boolean hasInfo(Collection<HighlightInfo> infos, int start, int end, String desc) {
        if (infos == null) {
            return false;
        }
        for (HighlightInfo info : infos) {
            if (info.startOffset != start || info.endOffset != end || !info.description.equals(desc)) continue;
            return true;
        }
        return false;
    }

    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, @NotNull Map<TextRange, Collection<HighlightInfo>> infos, int group) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setHighlightersToEditor must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setHighlightersToEditor must not be null");
        }
        if (infos == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setHighlightersToEditor must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        UpdateHighlightersUtil.cleanFileLevelHighlights(project, group, psiFile);
        ArrayList<TextRange> ranges = new ArrayList<TextRange>(infos.keySet());
        Collections.sort(ranges, BY_START_OFFSET);
        for (int i = 1; i < ranges.size(); ++i) {
            TextRange range = (TextRange)ranges.get(i);
            TextRange prev = (TextRange)ranges.get(i - 1);
            if (!prev.intersects(range)) continue;
            ranges.remove(i);
            TextRange union = prev.union(range);
            Collection<HighlightInfo> collection = infos.get(prev);
            collection.addAll(infos.get(range));
            infos.remove(prev);
            infos.remove(range);
            infos.put(union, collection);
            ranges.set(i - 1, union);
            --i;
        }
        MarkupModel markup = document.getMarkupModel(project);
        List<HighlightInfo> oldHighlights = DaemonCodeAnalyzerImpl.getHighlights(markup);
        List<HighlightInfo> oldHighlightsToRemove = DaemonCodeAnalyzerImpl.getHighlightsToRemove(markup);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, oldHighlights, oldHighlightsToRemove);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        RangeHighlightersToReuse infosToRemove = new RangeHighlightersToReuse();
        boolean changed = false;
        SmartList toRemoveInAnotherPass = new SmartList();
        if (oldHighlights != null) {
            List list = ContainerUtil.concat(oldHighlightsToRemove, oldHighlights);
            for (int i = 0; i < list.size(); ++i) {
                RangeHighlighterEx highlighter;
                HighlightInfo highlightInfo = (HighlightInfo)list.get(i);
                boolean toRemove = UpdateHighlightersUtil.isRemoving(group, ranges, highlightInfo, highlighter = highlightInfo.highlighter);
                if (toRemove) {
                    infosToRemove.add(highlighter);
                    changed = true;
                    continue;
                }
                if (i >= oldHighlightsToRemove.size()) {
                    result.add(highlightInfo);
                    continue;
                }
                toRemoveInAnotherPass.add(highlightInfo);
            }
        }
        THashMap ranges2markersCache = new THashMap(oldHighlights == null ? 10 : oldHighlights.size());
        for (TextRange textRange : ranges) {
            int rangeStartOffset = textRange.getStartOffset();
            int rangeEndOffset = textRange.getEndOffset();
            ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(infos.get(textRange));
            Collections.sort(highlights, new Comparator<HighlightInfo>(){

                @Override
                public int compare(HighlightInfo o1, HighlightInfo o2) {
                    return o1.startOffset - o2.startOffset;
                }
            });
            for (HighlightInfo info : highlights) {
                int docLength;
                if (info.isFileLevelAnnotation && psiFile != null && psiFile.getViewProvider().isPhysical()) {
                    UpdateHighlightersUtil.addFileLevelHighlight(project, group, info, psiFile);
                    continue;
                }
                int infoStartOffset = info.startOffset;
                int infoEndOffset = info.endOffset;
                if (infoStartOffset < rangeStartOffset || infoEndOffset > rangeEndOffset) continue;
                if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine) {
                    ++infoEndOffset;
                }
                if (infoEndOffset > (docLength = document.getTextLength())) {
                    infoEndOffset = docLength;
                }
                info.text = ((Object)document.getCharsSequence().subSequence(infoStartOffset, infoEndOffset)).toString();
                info.group = group;
                RangeHighlighterEx highlighter = (RangeHighlighterEx)infosToRemove.reuseHighlighterAt(info.startOffset, info.endOffset);
                if (highlighter == null) {
                    highlighter = UpdateHighlightersUtil.createRangeHighlighter(project, psiFile, info, infoStartOffset, infoEndOffset, markup);
                } else {
                    ((RangeHighlighterImpl)highlighter).setTextAttributes(info.getTextAttributes((PsiElement)psiFile));
                }
                changed = true;
                info.highlighter = highlighter;
                highlighter.setAfterEndOfLine(info.isAfterEndOfLine);
                Color color = info.getErrorStripeMarkColor((PsiElement)psiFile);
                highlighter.setErrorStripeMarkColor(color);
                if (!(highlighter.getErrorStripeTooltip() instanceof HighlightInfo) || !info.equalsByActualOffset((HighlightInfo)highlighter.getErrorStripeTooltip())) {
                    highlighter.setErrorStripeTooltip(info);
                }
                GutterIconRenderer renderer = info.getGutterIconRenderer();
                highlighter.setGutterIconRenderer(renderer);
                ranges2markersCache.put(new TextRange(infoStartOffset, infoEndOffset), info.highlighter);
                if (info.quickFixActionRanges != null) {
                    info.quickFixActionMarkers = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>>(info.quickFixActionRanges.size());
                    for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                        TextRange textRange2 = (TextRange)pair.second;
                        RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, (Map<TextRange, RangeMarker>)ranges2markersCache, textRange2);
                        info.quickFixActionMarkers.add((Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>)Pair.create((Object)pair.first, (Object)marker));
                    }
                }
                info.fixMarker = UpdateHighlightersUtil.getOrCreate(document, (Map<TextRange, RangeMarker>)ranges2markersCache, new TextRange(info.fixStartOffset, info.fixEndOffset));
                assert (Comparing.equal((Object)info.getTextAttributes((PsiElement)psiFile), (Object)highlighter.getTextAttributes())) : "Info: " + info.getTextAttributes((PsiElement)psiFile) + "; highlighter:" + highlighter.getTextAttributes();
                result.add(info);
            }
        }
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAll()) {
            markup.removeHighlighter(rangeHighlighter);
            changed = true;
        }
        if (changed) {
            DaemonCodeAnalyzerImpl.setHighlights(markup, project, result, (List<HighlightInfo>)toRemoveInAnotherPass);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, result, (List<HighlightInfo>)toRemoveInAnotherPass);
    }

    private static boolean isRemoving(int group, List<TextRange> ranges, HighlightInfo info, RangeHighlighter highlighter) {
        if (!highlighter.isValid()) {
            return true;
        }
        if (info.group != group) {
            return false;
        }
        TextRange toFind = new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset());
        int i = Collections.binarySearch(ranges, toFind, BY_START_OFFSET_OR_CONTAINS);
        if (i < 0) {
            return false;
        }
        Document document = highlighter.getDocument();
        if (highlighter.getEndOffset() == document.getTextLength() && ranges.get(ranges.size() - 1).getEndOffset() == document.getTextLength()) {
            return true;
        }
        TextRange containing = ranges.get(i);
        return containing.contains(toFind.getStartOffset());
    }

    private static RangeHighlighterEx createRangeHighlighter(Project project, PsiFile psiFile, HighlightInfo info, int infoStartOffset, int infoEndOffset, MarkupModel markup) {
        HighlightSeverity severity = info.getSeverity();
        int layer = severity == HighlightSeverity.WARNING ? 4000 : (SeverityRegistrar.getInstance(project).compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : 3000);
        return (RangeHighlighterEx)markup.addRangeHighlighter(infoStartOffset, infoEndOffset, layer, info.getTextAttributes((PsiElement)psiFile), HighlighterTargetArea.EXACT_RANGE);
    }

    private static RangeMarker getOrCreate(Document document, Map<TextRange, RangeMarker> ranges2markersCache, TextRange textRange) {
        RangeMarker marker = ranges2markersCache.get(textRange);
        if (marker == null) {
            marker = document.createRangeMarker(textRange);
            ranges2markersCache.put(textRange, marker);
        }
        return marker;
    }

    private static void addFileLevelHighlight(Project project, int group, HighlightInfo info, PsiFile psiFile) {
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component = new FileLevelIntentionComponent(info.description, info.severity, info.quickFixActionRanges, project, psiFile, ((TextEditor)fileEditor).getEditor());
            manager.showEditorAnnotation(fileEditor, (JComponent)((Object)component));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.fileLevelComponent = component;
            info.group = group;
            fileLevelInfos.add(info);
        }
    }

    public static void setLineMarkersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<LineMarkerInfo> markers, int group) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setLineMarkersToEditor must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setLineMarkersToEditor must not be null");
        }
        if (markers == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.setLineMarkersToEditor must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project);
        ArrayList<LineMarkerInfo> array = new ArrayList<LineMarkerInfo>(oldMarkers == null ? markers.size() : oldMarkers.size());
        MarkupModel markupModel = document.getMarkupModel(project);
        RangeHighlightersToReuse toReuse = new RangeHighlightersToReuse();
        if (oldMarkers != null) {
            for (LineMarkerInfo info : oldMarkers) {
                boolean toRemove;
                RangeHighlighter rangeHighlighter = info.highlighter;
                boolean bl = toRemove = !rangeHighlighter.isValid() || info.updatePass == group && startOffset <= rangeHighlighter.getStartOffset() && (rangeHighlighter.getEndOffset() < endOffset || rangeHighlighter.getEndOffset() == document.getTextLength());
                if (toRemove) {
                    toReuse.add(rangeHighlighter);
                    continue;
                }
                array.add(info);
            }
        }
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (LineMarkerInfo lineMarkerInfo : markers) {
            LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer;
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || startOffset > (elementRange = InjectedLanguageManager.getInstance((Project)project).injectedToHost(element, textRange)).getStartOffset() || elementRange.getEndOffset() > endOffset) continue;
            RangeHighlighter marker = toReuse.reuseHighlighterAt(lineMarkerInfo.startOffset, lineMarkerInfo.endOffset);
            if (marker == null) {
                marker = markupModel.addRangeHighlighter(lineMarkerInfo.startOffset, lineMarkerInfo.endOffset, 3000, null, HighlighterTargetArea.EXACT_RANGE);
            }
            LineMarkerInfo.LineMarkerGutterIconRenderer renderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)lineMarkerInfo.createGutterRenderer();
            LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerGutterIconRenderer = oldRenderer = marker.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)marker.getGutterIconRenderer() : null;
            if (oldRenderer == null || renderer == null || !renderer.looksTheSameAs(oldRenderer)) {
                marker.setGutterIconRenderer((GutterIconRenderer)renderer);
            }
            if (!Comparing.equal((Object)marker.getLineSeparatorColor(), (Object)lineMarkerInfo.separatorColor)) {
                marker.setLineSeparatorColor(lineMarkerInfo.separatorColor);
            }
            if (!Comparing.equal((Object)marker.getLineSeparatorPlacement(), (Object)lineMarkerInfo.separatorPlacement)) {
                marker.setLineSeparatorPlacement(lineMarkerInfo.separatorPlacement);
            }
            lineMarkerInfo.highlighter = marker;
            array.add(lineMarkerInfo);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAll()) {
            markupModel.removeHighlighter(rangeHighlighter);
        }
        DaemonCodeAnalyzerImpl.setLineMarkers(document, array, project);
    }

    public static boolean isWhitespaceOptimizationAllowed(Document document) {
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(Document document) {
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, (Object)Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(Document document) {
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    public static void updateHighlightersByTyping(@NotNull Project project, @NotNull DocumentEvent e) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.updateHighlightersByTyping must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.updateHighlightersByTyping must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = document.getMarkupModel(project);
        List<HighlightInfo> oldHighlights = DaemonCodeAnalyzerImpl.getHighlights(markup);
        if (oldHighlights == null || oldHighlights.isEmpty()) {
            return;
        }
        int offset = e.getOffset();
        Editor[] editors = EditorFactory.getInstance().getEditors(document, project);
        if (editors.length == 0) {
            return;
        }
        Editor editor = editors[0];
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(Math.max(0, offset - 1));
        if (iterator.atEnd()) {
            return;
        }
        int start = iterator.getStart();
        while (iterator.getEnd() < e.getOffset() + e.getNewLength()) {
            iterator.advance();
            if (!iterator.atEnd()) continue;
            return;
        }
        int end = iterator.getEnd();
        ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>(DaemonCodeAnalyzerImpl.getHighlightsToRemove(markup));
        boolean highlightersChanged = false;
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(oldHighlights.size());
        boolean documentChangedInsideHighlighter = false;
        for (HighlightInfo info : oldHighlights) {
            RangeHighlighterEx highlighter = info.highlighter;
            boolean toRemove = false;
            if (info.needUpdateOnTyping()) {
                int highlighterStart = highlighter.getStartOffset();
                int highlighterEnd = highlighter.getEndOffset();
                if (info.isAfterEndOfLine) {
                    if (highlighterStart < document.getTextLength()) {
                        ++highlighterStart;
                    }
                    if (highlighterEnd < document.getTextLength()) {
                        ++highlighterEnd;
                    }
                }
                if (!highlighter.isValid()) {
                    toRemove = true;
                } else if (start < highlighterEnd && highlighterStart <= end) {
                    documentChangedInsideHighlighter = true;
                    toRemove = true;
                }
            }
            if (toRemove) {
                if (info.type.equals(HighlightInfoType.WRONG_REF)) {
                    markup.removeHighlighter((RangeHighlighter)highlighter);
                } else {
                    infosToRemove.add(info);
                }
                highlightersChanged = true;
                continue;
            }
            result.add(info);
        }
        if (highlightersChanged) {
            DaemonCodeAnalyzerImpl.setHighlights(markup, project, result, infosToRemove);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, result, infosToRemove);
        if (highlightersChanged || documentChangedInsideHighlighter) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    @NotNull
    public static List<HighlightInfo> getFileLeveleHighlights(Project project, PsiFile file) {
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            for (HighlightInfo info : infos) {
                result.add(info);
            }
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil.getFileLeveleHighlights must not return null");
        }
        return arrayList;
    }

    private static void assertMarkupConsistent(MarkupModel markup, List<HighlightInfo> highlightsToSet, List<HighlightInfo> highlightsToRemove) {
        if (DEBUG) {
            RangeHighlighter[] allHighlighters;
            if (highlightsToSet != null) {
                for (HighlightInfo info : highlightsToSet) {
                    assert (((MarkupModelEx)markup).containsHighlighter(info.highlighter));
                }
            }
            for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
                Object tooltip = highlighter.getErrorStripeTooltip();
                if (!(tooltip instanceof HighlightInfo)) continue;
                HighlightInfo info = (HighlightInfo)tooltip;
                assert (highlightsToSet != null && highlightsToSet.contains(info) || highlightsToRemove != null && highlightsToRemove.contains(info));
            }
        }
    }

    private static class RangeHighlightersToReuse {
        private final MultiMap<TextRange, RangeHighlighter> info2Pass = new MultiMap<TextRange, RangeHighlighter>(){

            protected Map<TextRange, Collection<RangeHighlighter>> createMap() {
                return new THashMap();
            }

            protected Collection<RangeHighlighter> createCollection() {
                return new SmartList();
            }
        };

        private RangeHighlightersToReuse() {
        }

        void add(RangeHighlighter highlighter) {
            this.info2Pass.putValue((Object)InjectedLanguageUtil.toTextRange((RangeMarker)highlighter), (Object)highlighter);
        }

        RangeHighlighter reuseHighlighterAt(int startOffset, int endOffset) {
            TextRange range = new TextRange(startOffset, endOffset);
            Collection collection = this.info2Pass.get((Object)range);
            for (RangeHighlighter highlighter : collection) {
                if (!highlighter.isValid()) continue;
                this.info2Pass.removeValue((Object)range, (Object)highlighter);
                return highlighter;
            }
            return null;
        }

        Collection<? extends RangeHighlighter> forAll() {
            return this.info2Pass.values();
        }
    }
}

