/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.PostHighlightingPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostHighlightingPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public PostHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, 5);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("PostHighlightingPassFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory.getComponentName must not return null");
        }
        return "PostHighlightingPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory.createHighlightingPass must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory.createHighlightingPass must not be null");
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 4);
        if (textRange == null) {
            return null;
        }
        int startOffset = 0;
        int endOffset = editor.getDocument().getTextLength();
        return new PostHighlightingPass(this.myProject, file, editor, startOffset, endOffset);
    }
}

