/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobImpl;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class PassExecutorService
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PassExecutorService");
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
    private final Project myProject;
    private volatile boolean isDisposed;
    private final AtomicInteger nextPassId = new AtomicInteger(100);
    private static final ConcurrentHashMap<Thread, Integer> threads = new ConcurrentHashMap();

    public PassExecutorService(Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        this.cancelAll(true);
        this.isDisposed = true;
    }

    public void cancelAll(boolean waitForTermination) {
        for (Job<Void> submittedPass : this.mySubmittedPasses.values()) {
            submittedPass.cancel();
        }
        if (waitForTermination) {
            for (Job<Void> job : this.mySubmittedPasses.values()) {
                try {
                    if (job.isDone()) continue;
                    ((JobImpl)job).waitForTermination();
                }
                catch (Throwable throwable) {
                    LOG.error(throwable);
                }
            }
        }
        this.mySubmittedPasses.clear();
    }

    public void submitPasses(Map<FileEditor, HighlightingPass[]> passesMap, DaemonProgressIndicator updateProgress, int jobPriority) {
        if (this.isDisposed()) {
            return;
        }
        int id = 1;
        THashMap toBeSubmitted = new THashMap(passesMap.size());
        HashMap<Document, List> documentToEditors = new HashMap<Document, List>();
        HashMap<FileEditor, List> textPasses = new HashMap<FileEditor, List>(passesMap.size());
        boolean dumb = DumbService.getInstance((Project)this.myProject).isDumb();
        for (Map.Entry<FileEditor, HighlightingPass[]> entry : passesMap.entrySet()) {
            FileEditor fileEditor = entry.getKey();
            HighlightingPass[] passes = entry.getValue();
            Document document = null;
            if (fileEditor instanceof TextEditor) {
                Editor editor = ((TextEditor)fileEditor).getEditor();
                document = editor.getDocument();
            }
            for (int i = 0; i < passes.length; ++i) {
                TextEditorHighlightingPass textEditorHighlightingPass;
                final HighlightingPass pass = passes[i];
                if (dumb && !(pass instanceof DumbAware)) continue;
                if (pass instanceof TextEditorHighlightingPass) {
                    textEditorHighlightingPass = (TextEditorHighlightingPass)pass;
                } else {
                    textEditorHighlightingPass = new TextEditorHighlightingPass(this.myProject, document, true){

                        @Override
                        public void doCollectInformation(ProgressIndicator progress) {
                            pass.collectInformation(progress);
                        }

                        @Override
                        public void doApplyInformationToEditor() {
                            pass.applyInformationToEditor();
                        }
                    };
                    textEditorHighlightingPass.setId(id++);
                    if (i > 0) {
                        textEditorHighlightingPass.setCompletionPredecessorIds(new int[]{i - 1});
                    }
                }
                document = textEditorHighlightingPass.getDocument();
                List textPassesForDocument = (List)textPasses.get(fileEditor);
                if (textPassesForDocument == null) {
                    textPassesForDocument = new SmartList();
                    textPasses.put(fileEditor, textPassesForDocument);
                }
                textPassesForDocument.add(textEditorHighlightingPass);
                List editors = (List)documentToEditors.get(document);
                if (editors == null) {
                    editors = new SmartList();
                    documentToEditors.put(document, editors);
                }
                if (editors.contains(fileEditor)) continue;
                editors.add(fileEditor);
            }
        }
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(documentToEditors.size());
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (List fileEditors : documentToEditors.values()) {
            List passes = (List)textPasses.get(fileEditors.get(0));
            threadsToStartCountdown.addAndGet(passes.size());
            ContainerUtil.quickSort((List)passes, (Comparator)new Comparator<TextEditorHighlightingPass>(){

                @Override
                public int compare(TextEditorHighlightingPass o1, TextEditorHighlightingPass o2) {
                    return o1.getId() - o2.getId();
                }
            });
            int passId = -1;
            TextEditorHighlightingPass currentPass = null;
            for (int i = 0; i <= passes.size(); ++i) {
                int newId = -1;
                if (i < passes.size()) {
                    currentPass = (TextEditorHighlightingPass)passes.get(i);
                    newId = currentPass.getId();
                }
                if (newId == passId) continue;
                this.createScheduledPass(fileEditors, currentPass, (Map<Pair<Document, Integer>, ScheduledPass>)toBeSubmitted, passes, freePasses, updateProgress, threadsToStartCountdown, jobPriority);
                passId = newId;
            }
        }
        PassExecutorService.log(updateProgress, null, "---------------------starting------------------------ " + threadsToStartCountdown.get());
        for (ScheduledPass freePass : freePasses) {
            this.submit(freePass);
        }
    }

    private ScheduledPass createScheduledPass(@NotNull List<FileEditor> fileEditors, @NotNull TextEditorHighlightingPass pass, @NotNull Map<Pair<Document, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, int jobPriority) {
        ScheduledPass predecessor;
        if (fileEditors == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        if (pass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        if (toBeSubmitted == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        if (freePasses == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        if (threadsToStartCountdown == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService.createScheduledPass must not be null");
        }
        int passId = pass.getId();
        Document document = pass.getDocument();
        Pair key = Pair.create((Object)document, (Object)passId);
        ScheduledPass scheduledPass = toBeSubmitted.get(key);
        if (scheduledPass != null) {
            return scheduledPass;
        }
        scheduledPass = new ScheduledPass(fileEditors, pass, updateProgress, threadsToStartCountdown, jobPriority);
        toBeSubmitted.put((Pair<Document, Integer>)key, scheduledPass);
        for (int predecessorId : pass.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditors, document, toBeSubmitted, textEditorHighlightingPasses, freePasses, updateProgress, threadsToStartCountdown, jobPriority, predecessorId, passId);
            if (predecessor == null) continue;
            predecessor.mySuccessorsOnCompletion.add(scheduledPass);
            scheduledPass.myRunningPredecessorsCount.incrementAndGet();
        }
        for (int predecessorId : pass.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditors, document, toBeSubmitted, textEditorHighlightingPasses, freePasses, updateProgress, threadsToStartCountdown, jobPriority, predecessorId, passId);
            if (predecessor == null) continue;
            predecessor.mySuccessorsOnSubmit.add(scheduledPass);
            scheduledPass.myRunningPredecessorsCount.incrementAndGet();
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        }
        return scheduledPass;
    }

    private ScheduledPass findOrCreatePredecessorPass(List<FileEditor> fileEditors, Document document, Map<Pair<Document, Integer>, ScheduledPass> toBeSubmitted, List<TextEditorHighlightingPass> textEditorHighlightingPasses, List<ScheduledPass> freePasses, DaemonProgressIndicator updateProgress, AtomicInteger myThreadsToStartCountdown, int jobPriority, int predecessorId, int passId) {
        Pair predkey = Pair.create((Object)document, (Object)predecessorId);
        ScheduledPass predecessor = toBeSubmitted.get(predkey);
        if (predecessor == null) {
            TextEditorHighlightingPass textEditorPass = PassExecutorService.findPassById(predecessorId, textEditorHighlightingPasses);
            if (textEditorPass == null && predecessorId == 2 && passId != 4 && PassExecutorService.findPassById(4, textEditorHighlightingPasses) != null) {
                return this.findOrCreatePredecessorPass(fileEditors, document, toBeSubmitted, textEditorHighlightingPasses, freePasses, updateProgress, myThreadsToStartCountdown, jobPriority, 4, passId);
            }
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditors, textEditorPass, toBeSubmitted, textEditorHighlightingPasses, freePasses, updateProgress, myThreadsToStartCountdown, jobPriority);
        }
        return predecessor;
    }

    private static TextEditorHighlightingPass findPassById(int id, List<TextEditorHighlightingPass> textEditorHighlightingPasses) {
        TextEditorHighlightingPass textEditorPass = null;
        for (TextEditorHighlightingPass found : textEditorHighlightingPasses) {
            if (found.getId() != id) continue;
            textEditorPass = found;
            break;
        }
        return textEditorPass;
    }

    private void submit(ScheduledPass pass) {
        if (!pass.myUpdateProgress.isCanceled()) {
            Job job = JobScheduler.getInstance().createJob(pass.myPass.toString(), pass.myJobPriority);
            job.addTask((Runnable)pass);
            job.schedule();
            this.mySubmittedPasses.put(pass, (Job<Void>)job);
        }
    }

    public void renewVisiblePasses(TextEditor textEditor, HighlightingPass[] highlightingPasses, DaemonProgressIndicator visibleProgress) {
        for (ScheduledPass pass : this.mySubmittedPasses.keySet()) {
            if (pass.myUpdateProgress != visibleProgress) continue;
            return;
        }
        Map<TextEditor, HighlightingPass[]> passes = Collections.singletonMap(textEditor, highlightingPasses);
        this.submitPasses(passes, visibleProgress, 90);
    }

    protected void applyInformationToEditors(final List<FileEditor> fileEditors, final TextEditorHighlightingPass pass, final DaemonProgressIndicator updateProgress, final AtomicInteger threadsToStartCountdown) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PassExecutorService.this.doApplyInformationToEditors(updateProgress, pass, fileEditors, threadsToStartCountdown, true);
                }
            });
        } else {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    PassExecutorService.this.doApplyInformationToEditors(updateProgress, pass, fileEditors, threadsToStartCountdown, false);
                }
            }, ModalityState.stateForComponent((Component)fileEditors.get(0).getComponent()));
        }
    }

    private void doApplyInformationToEditors(DaemonProgressIndicator updateProgress, TextEditorHighlightingPass pass, List<FileEditor> fileEditors, AtomicInteger threadsToStartCountdown, boolean testMode) {
        if (this.isDisposed() || this.myProject.isDisposed()) {
            updateProgress.cancel();
        }
        if (updateProgress.isCanceled()) {
            PassExecutorService.log(updateProgress, pass, " is canceled during apply, sorry");
            return;
        }
        boolean applied = false;
        for (FileEditor fileEditor : fileEditors) {
            LOG.assertTrue(fileEditor != null);
            try {
                if (!testMode && !fileEditor.getComponent().isDisplayable()) continue;
                if (!applied) {
                    applied = true;
                    PassExecutorService.log(updateProgress, pass, " Applied");
                    pass.applyInformationToEditor();
                }
                this.afterApplyInformationToEditor(pass, fileEditor, updateProgress);
                if (!pass.isRunIntentionPassAfter() || !(fileEditor instanceof TextEditor) || updateProgress.isCanceled()) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                ShowIntentionsPass ip = new ShowIntentionsPass(this.myProject, editor, -1);
                ip.setId(this.nextPassId.incrementAndGet());
                threadsToStartCountdown.incrementAndGet();
                this.submit(new ScheduledPass(fileEditors, ip, updateProgress, threadsToStartCountdown, 100));
            }
            catch (RuntimeException e) {
                PassExecutorService.log(updateProgress, pass, "Error " + e);
                throw e;
            }
        }
        if (threadsToStartCountdown.decrementAndGet() == 0) {
            PassExecutorService.log(updateProgress, pass, "Stopping ");
            updateProgress.stopIfRunning();
        } else {
            PassExecutorService.log(updateProgress, pass, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
        }
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    protected abstract void afterApplyInformationToEditor(TextEditorHighlightingPass var1, FileEditor var2, ProgressIndicator var3);

    public List<TextEditorHighlightingPass> getAllSubmittedPasses() {
        ArrayList<TextEditorHighlightingPass> result = new ArrayList<TextEditorHighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            result.add(scheduledPass.myPass);
        }
        return result;
    }

    private static int getThreadNum() {
        return (Integer)ConcurrencyUtil.cacheOrGet(threads, (Object)Thread.currentThread(), (Object)threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void log(ProgressIndicator progressIndicator, TextEditorHighlightingPass pass, Object ... info) {
        if (!LOG.isDebugEnabled()) return;
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            StringBuilder s = new StringBuilder();
            for (Object o : info) {
                s.append(o.toString());
            }
            LOG.debug(StringUtil.repeatSymbol((char)' ', (int)(PassExecutorService.getThreadNum() * 4)) + " " + pass + " " + s + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + " : '" + (pass == null ? "" : StringUtil.first((String)pass.getDocument().getText(), (int)10, (boolean)true)) + "'");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private class ScheduledPass
    implements Runnable {
        private final List<FileEditor> myFileEditors;
        private final TextEditorHighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final int myJobPriority;
        private final AtomicInteger myRunningPredecessorsCount;
        private final Collection<ScheduledPass> mySuccessorsOnCompletion;
        private final Collection<ScheduledPass> mySuccessorsOnSubmit;
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull List<FileEditor> fileEditors, @NotNull TextEditorHighlightingPass pass, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown, int jobPriority) {
            if (fileEditors == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass.<init> must not be null");
            }
            if (pass == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass.<init> must not be null");
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass.<init> must not be null");
            }
            if (threadsToStartCountdown == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass.<init> must not be null");
            }
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditors = fileEditors;
            this.myPass = pass;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myJobPriority = jobPriority;
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            int predecessorsToRun;
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(new Runnable(){

                @Override
                public void run() {
                    boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (DumbService.getInstance((Project)PassExecutorService.this.myProject).isDumb() && !(ScheduledPass.this.myPass instanceof DumbAware)) {
                                    return;
                                }
                                if (!ScheduledPass.this.myUpdateProgress.isCanceled()) {
                                    ScheduledPass.this.myPass.collectInformation(ScheduledPass.this.myUpdateProgress);
                                }
                            }
                            catch (ProcessCanceledException e) {
                                PassExecutorService.log(ScheduledPass.this.myUpdateProgress, ScheduledPass.this.myPass, "Canceled ");
                                ScheduledPass.this.myUpdateProgress.cancel();
                            }
                            catch (RuntimeException e) {
                                LOG.error((Throwable)e);
                                throw e;
                            }
                            catch (Error e) {
                                LOG.error((Throwable)e);
                                throw e;
                            }
                        }
                    });
                    if (!success) {
                        ScheduledPass.this.myUpdateProgress.cancel();
                    }
                }
            }, this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditors(this.myFileEditors, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown);
                for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                    predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                    if (predecessorsToRun != 0) continue;
                    PassExecutorService.this.submit(successor);
                }
            }
        }
    }
}

