/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.JavaCompletionData;
import com.intellij.codeInsight.completion.KeywordChooser;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.classes.InterfaceFilter;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ModifierChooser
implements KeywordChooser {
    private static final Map<ElementFilter, String[][]> myMap = new HashMap();

    @Override
    public String[] getKeywords(CompletionContext context, PsiElement position) {
        ArrayList<String> ret;
        block8: {
            ret = new ArrayList<String>();
            try {
                Object scope = position == null ? context.file : position.getParent();
                PsiModifierList list = ModifierChooser.getModifierList(position);
                while (scope != null) {
                    for (ElementFilter o : myMap.keySet()) {
                        ElementFilter filter = o;
                        if (!filter.isClassAcceptable(scope.getClass()) || !filter.isAcceptable(scope, scope.getParent())) continue;
                        String[][] keywordSets = myMap.get(filter);
                        for (int i = 0; i < keywordSets.length; ++i) {
                            String[] keywords = keywordSets[keywordSets.length - i - 1];
                            boolean containModifierFlag = false;
                            if (list != null) {
                                for (String keyword : keywords) {
                                    if (!list.hasModifierProperty(keyword)) continue;
                                    containModifierFlag = true;
                                    break;
                                }
                            }
                            if (containModifierFlag) continue;
                            ret.addAll(Arrays.asList(keywords));
                        }
                        break block8;
                    }
                    if ((scope = scope.getParent()) instanceof JspClassLevelDeclarationStatement) {
                        scope = scope.getContext();
                    }
                    if (!(scope instanceof PsiDirectory)) continue;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ArrayUtil.toStringArray(ret);
    }

    private static PsiModifierList getModifierList(PsiElement element) throws Exception {
        PsiModifierList modifierList;
        if (element == null) {
            return null;
        }
        if (element.getParent() instanceof PsiModifierList) {
            return (PsiModifierList)element.getParent();
        }
        PsiElement prev = FilterPositionUtil.searchNonSpaceNonCommentBack(element);
        if (prev != null && (modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiModifierList.class)) != null) {
            return modifierList;
        }
        PsiElement parent = element.getParent();
        while (parent != null && (parent instanceof PsiJavaCodeReferenceElement || parent instanceof PsiErrorElement || parent instanceof PsiTypeElement || parent instanceof PsiMethod || parent instanceof PsiVariable || parent instanceof PsiDeclarationStatement || parent instanceof PsiImportList || parent instanceof PsiDocComment || element.getText().equals(parent.getText()))) {
            if (!((parent = parent.getParent()) instanceof JspClassLevelDeclarationStatement)) continue;
            parent = parent.getContext();
        }
        if (parent == null) {
            throw new Exception();
        }
        for (ElementFilter o : myMap.keySet()) {
            ElementFilter filter = o;
            if (!filter.isClassAcceptable(parent.getClass()) || !filter.isAcceptable((Object)parent, parent.getParent()) || !(parent instanceof PsiParameterList ? prev == null || Arrays.asList("(", ",").contains(prev.getText()) || Arrays.asList("(", ",").contains(element.getText()) : prev == null || JavaCompletionData.END_OF_BLOCK.isAcceptable((Object)element, prev.getParent()))) continue;
            return null;
        }
        throw new Exception("Can't find modifier list");
    }

    public String toString() {
        return "modifier-chooser";
    }

    static {
        myMap.put(new NotFilter(new InterfaceFilter()), new String[][]{{"public", "protected", "private"}, {"static"}, {"final", "abstract"}, {"native"}, {"synchronized"}, {"strictfp"}, {"volatile"}, {"transient"}});
        myMap.put(new InterfaceFilter(), new String[][]{{"public", "protected"}, {"static"}, {"final"}});
        myMap.put(new ClassFilter(PsiJavaFile.class), new String[][]{{"public"}, {"final", "abstract"}});
        myMap.put(new OrFilter(new ClassFilter(PsiStatement.class), new ClassFilter(PsiCodeBlock.class)), new String[][]{{"final", "synchronized"}});
        myMap.put(new ClassFilter(PsiParameterList.class), new String[][]{{"final"}});
    }
}

