/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceParameter.java2groovy;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class OldReferencesResolver {
    private final GrCall myContext;
    private final GrExpression myExpr;
    private final HashMap<GrExpression, String> myTempVars;
    private final GrExpression myInstanceRef;
    private final GrExpression[] myActualArgs;
    private final PsiMethod myMethodToReplaceIn;
    private final Project myProject;
    private final int myReplaceFieldsWithGetters;
    private final PsiExpression myParameterInitializer;
    private final PsiManager myManager;

    public OldReferencesResolver(GrCall context, GrExpression expr, PsiMethod methodToReplaceIn, int replaceFieldsWithGetters, PsiExpression parameterInitializer) throws IncorrectOperationException {
        GrMethodCallExpression methodCall;
        GrExpression methodExpression;
        this.myContext = context;
        this.myExpr = expr;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
        this.myParameterInitializer = parameterInitializer;
        this.myTempVars = new HashMap();
        this.myActualArgs = this.myContext.getArgumentList().getExpressionArguments();
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myProject = this.myContext.getProject();
        this.myManager = this.myContext.getManager();
        this.myInstanceRef = this.myContext instanceof GrMethodCallExpression ? ((methodExpression = (methodCall = (GrMethodCallExpression)this.myContext).getInvokedExpression()) instanceof GrReferenceExpression ? ((GrReferenceExpression)methodExpression).getQualifierExpression() : null) : null;
    }

    public void resolve() throws IncorrectOperationException {
        this.resolveOldReferences(this.myExpr, (PsiElement)this.myParameterInitializer);
        Set mappingsSet = this.myTempVars.entrySet();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (Map.Entry entry : mappingsSet) {
            GrExpression oldRef = (GrExpression)entry.getKey();
            GrExpression newRef = factory.createExpressionFromText((String)entry.getValue());
            oldRef.replace(newRef);
        }
    }

    private void resolveOldReferences(PsiElement expr, PsiElement oldExpr) throws IncorrectOperationException {
        block26: {
            int oldCount;
            PsiElement[] newChildren;
            PsiElement[] oldChildren;
            PsiElement newExpr;
            block25: {
                if (expr == null || !expr.isValid() || oldExpr == null) {
                    return;
                }
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
                newExpr = expr;
                if (oldExpr instanceof PsiReferenceExpression) {
                    PsiReferenceExpression oldRef = (PsiReferenceExpression)oldExpr;
                    newExpr = newExpr.replace((PsiElement)OldReferencesResolver.decodeReferenceExpression((GrReferenceExpression)newExpr, oldRef));
                    JavaResolveResult adv = oldRef.advancedResolve(false);
                    PsiElement scope = OldReferencesResolver.getClassContainingResolve(adv);
                    PsiElement owner = PsiTreeUtil.getParentOfType((PsiElement)oldExpr, PsiClass.class);
                    if (owner != null && scope != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)scope, (boolean)false)) {
                        PsiElement subj = adv.getElement();
                        if (subj instanceof PsiParameter) {
                            PsiParameterList parameterList = this.myMethodToReplaceIn.getParameterList();
                            PsiParameter[] parameters = parameterList.getParameters();
                            if (subj.getParent() != parameterList) {
                                return;
                            }
                            int index = parameterList.getParameterIndex((PsiParameter)subj);
                            if (index < 0) {
                                return;
                            }
                            if (index < parameters.length) {
                                GrExpression actualArg = this.myActualArgs[index];
                                int copyingSafetyLevel = GroovyRefactoringUtil.verifySafeCopyExpression(actualArg);
                                if (copyingSafetyLevel == 2) {
                                    actualArg = factory.createExpressionFromText(this.getTempVar(actualArg));
                                }
                                newExpr = newExpr.replace((PsiElement)actualArg);
                            }
                        } else if ((subj instanceof PsiField || subj instanceof PsiMethod) && oldRef.getQualifierExpression() == null) {
                            boolean isStatic;
                            boolean bl = isStatic = subj instanceof PsiField && ((PsiField)subj).hasModifierProperty("static") || subj instanceof PsiMethod && ((PsiMethod)subj).hasModifierProperty("static");
                            if (this.myInstanceRef != null && !isStatic) {
                                String name = ((PsiNamedElement)subj).getName();
                                GrReferenceExpression newRef = (GrReferenceExpression)factory.createExpressionFromText("a." + name);
                                GrExpression instanceRef = this.getInstanceRef(factory);
                                newRef.getQualifierExpression().replace(instanceRef);
                                newRef = (GrReferenceExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newRef);
                                newRef = (GrReferenceExpression)newExpr.replace((PsiElement)newRef);
                                newExpr = newRef.getReferenceNameElement();
                            }
                        }
                        if (subj instanceof PsiField && this.myReplaceFieldsWithGetters != 0 && (this.myReplaceFieldsWithGetters == 2 || this.myReplaceFieldsWithGetters == 1 && !JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)subj, newExpr, null))) {
                            newExpr = this.replaceFieldWithGetter(newExpr, (PsiField)subj);
                        }
                    }
                } else {
                    String qualifiedName;
                    PsiReference ref;
                    if (oldExpr instanceof PsiThisExpression && (((PsiThisExpression)oldExpr).getQualifier() == null || this.myManager.areElementsEquivalent(((PsiThisExpression)oldExpr).getQualifier().resolve(), (PsiElement)this.myMethodToReplaceIn.getContainingClass()))) {
                        if (this.myInstanceRef != null) {
                            newExpr.replace((PsiElement)this.getInstanceRef(factory));
                        }
                        return;
                    }
                    if (oldExpr instanceof PsiSuperExpression && ((PsiSuperExpression)oldExpr).getQualifier() == null) {
                        if (this.myInstanceRef != null) {
                            newExpr.replace((PsiElement)this.getInstanceRef(factory));
                        }
                        return;
                    }
                    PsiClass refClass = (PsiClass)oldExpr.getCopyableUserData(ChangeContextUtil.REF_CLASS_KEY);
                    if (refClass != null && refClass.isValid() && (ref = newExpr.getReference()) != null && (qualifiedName = refClass.getQualifiedName()) != null && JavaPsiFacade.getInstance((Project)refClass.getProject()).findClass(qualifiedName, oldExpr.getResolveScope()) != null) {
                        newExpr = ref.bindToElement((PsiElement)refClass);
                    }
                }
                oldChildren = oldExpr.getChildren();
                newChildren = newExpr.getChildren();
                if (!(oldExpr instanceof PsiNewExpression) || !(newExpr instanceof GrNewExpression)) break block25;
                this.resolveOldReferences(((GrNewExpression)newExpr).getReferenceElement(), (PsiElement)((PsiNewExpression)oldExpr).getClassOrAnonymousClassReference());
                this.resolveOldReferences(((GrNewExpression)newExpr).getArgumentList(), (PsiElement)((PsiNewExpression)oldExpr).getArgumentList());
                if (!(newChildren[1] instanceof GrArrayDeclaration)) break block26;
                int j = 3;
                for (GrExpression expression : ((GrArrayDeclaration)newChildren[1]).getBoundExpressions()) {
                    while (!(oldChildren[j] instanceof CompositePsiElement)) {
                        ++j;
                    }
                    this.resolveOldReferences(expression, oldChildren[j]);
                    ++j;
                }
                break block26;
            }
            if (oldExpr instanceof PsiReferenceExpression && newExpr instanceof GrReferenceExpression) {
                PsiExpression oldQualifier = ((PsiReferenceExpression)oldExpr).getQualifierExpression();
                GrExpression newQualifier = ((GrReferenceExpression)newExpr).getQualifierExpression();
                if (oldQualifier != null && newQualifier != null) {
                    this.resolveOldReferences(newQualifier, (PsiElement)oldQualifier);
                    return;
                }
            }
            if ((oldCount = OldReferencesResolver.countOldChildren(oldChildren)) == newChildren.length) {
                int j = 0;
                for (int i = 0; i < newChildren.length; ++i) {
                    while (!(oldChildren[j] instanceof CompositePsiElement)) {
                        ++j;
                    }
                    this.resolveOldReferences(newChildren[i], oldChildren[j]);
                    ++j;
                }
            }
        }
    }

    private static int countOldChildren(PsiElement[] children) {
        int count = 0;
        for (PsiElement child : children) {
            if (!(child instanceof CompositePsiElement)) continue;
            ++count;
        }
        return count;
    }

    private GrExpression getInstanceRef(GroovyPsiElementFactory factory) throws IncorrectOperationException {
        int copyingSafetyLevel = GroovyRefactoringUtil.verifySafeCopyExpression(this.myInstanceRef);
        GrExpression instanceRef = this.myInstanceRef;
        if (copyingSafetyLevel == 2) {
            instanceRef = factory.createExpressionFromText(this.getTempVar(this.myInstanceRef));
        }
        return instanceRef;
    }

    private String getTempVar(GrExpression expr) throws IncorrectOperationException {
        String id = (String)this.myTempVars.get((Object)expr);
        if (id != null) {
            return id;
        }
        id = GroovyRefactoringUtil.createTempVar(expr, this.myContext, true);
        this.myTempVars.put((Object)expr, (Object)id);
        return id;
    }

    private PsiElement replaceFieldWithGetter(PsiElement expr, PsiField psiField) throws IncorrectOperationException {
        if (RefactoringUtil.isAssignmentLHS((PsiElement)expr)) {
            return expr;
        }
        Object newExpr = expr;
        PsiMethod getterPrototype = PropertyUtil.generateGetterPrototype((PsiField)psiField);
        PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
        if (getter != null && JavaPsiFacade.getInstance((Project)psiField.getProject()).getResolveHelper().isAccessible((PsiMember)getter, newExpr, null)) {
            GrExpression qualifierExpression;
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(newExpr.getProject());
            String id = getter.getName();
            PsiElement parent = newExpr.getParent();
            String qualifier = null;
            if (parent instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)parent).getQualifierExpression()) != null) {
                qualifier = qualifierExpression.getText();
            }
            GrMethodCallExpression getterCall = (GrMethodCallExpression)factory.createExpressionFromText((qualifier != null ? qualifier + "." : "") + id + "()");
            getterCall = (GrMethodCallExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)getterCall);
            newExpr = parent != null ? parent.replace((PsiElement)getterCall) : getterCall;
        }
        return newExpr;
    }

    @Nullable
    private static PsiElement getClassContainingResolve(JavaResolveResult result) {
        PsiElement elem = result.getElement();
        if (elem != null) {
            if (elem instanceof PsiLocalVariable || elem instanceof PsiParameter) {
                return PsiTreeUtil.getParentOfType((PsiElement)elem, PsiClass.class);
            }
            return result.getCurrentFileResolveScope();
        }
        return null;
    }

    private static GrReferenceExpression decodeReferenceExpression(GrReferenceExpression newExpr, PsiReferenceExpression refExpr) throws IncorrectOperationException {
        PsiManager manager = refExpr.getManager();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(manager.getProject());
        PsiExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            PsiMember refMember = (PsiMember)refExpr.getCopyableUserData(ChangeContextUtil.REF_MEMBER_KEY);
            refExpr.putCopyableUserData(ChangeContextUtil.REF_MEMBER_KEY, null);
            if (refMember != null && refMember.isValid()) {
                PsiElement refElement;
                PsiClass containingClass = refMember.getContainingClass();
                if (refMember.hasModifierProperty("static") && !manager.areElementsEquivalent((PsiElement)refMember, refElement = newExpr.resolve())) {
                    newExpr.setQualifierExpression(factory.createReferenceExpressionFromText("" + containingClass.getQualifiedName()));
                }
            } else {
                PsiClass refClass = (PsiClass)refExpr.getCopyableUserData(ChangeContextUtil.REF_CLASS_KEY);
                refExpr.putCopyableUserData(ChangeContextUtil.REF_CLASS_KEY, null);
                if (refClass != null && refClass.isValid()) {
                    newExpr = (GrReferenceExpression)newExpr.bindToElement((PsiElement)refClass);
                }
            }
        } else {
            Boolean couldRemove = (Boolean)refExpr.getCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY);
            refExpr.putCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY, null);
            if (couldRemove == Boolean.FALSE && OldReferencesResolver.canRemoveQualifier(refExpr)) {
                GrReferenceExpression newRefExpr = (GrReferenceExpression)factory.createExpressionFromText(refExpr.getReferenceName());
                newExpr = (GrReferenceExpression)newExpr.replace(newRefExpr);
            }
        }
        return newExpr;
    }

    private static boolean canRemoveQualifier(PsiReferenceExpression refExpr) {
        try {
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement qualifierRefElement = ((PsiReferenceExpression)qualifier).resolve();
            if (!(qualifierRefElement instanceof PsiClass)) {
                return false;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement == null) {
                return false;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory();
            if (refExpr.getParent() instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)refExpr.getParent();
                PsiMethodCallExpression newMethodCall = (PsiMethodCallExpression)factory.createExpressionFromText(refExpr.getReferenceName() + "()", (PsiElement)refExpr);
                newMethodCall.getArgumentList().replace((PsiElement)methodCall.getArgumentList());
                PsiElement newRefElement = newMethodCall.getMethodExpression().resolve();
                return refElement.equals(newRefElement);
            }
            PsiReferenceExpression newRefExpr = (PsiReferenceExpression)factory.createExpressionFromText(refExpr.getReferenceName(), (PsiElement)refExpr);
            PsiElement newRefElement = newRefExpr.resolve();
            return refElement.equals(newRefElement);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }
}

