/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;

public class TypeInferenceHelper {
    private final ConcurrentWeakHashMap<GroovyPsiElement, Map<GrReferenceExpression, PsiType>> myCalculatedTypeInferences = new ConcurrentWeakHashMap();
    private static final ThreadLocal<Map<String, PsiType>> myCurrentEnvironment = new ThreadLocal();
    private static final ThreadLocal<Set<GroovyPsiElement>> myScopesBeingInferred = new ThreadLocal();

    public TypeInferenceHelper(Project project) {
        ((PsiManagerEx)PsiManager.getInstance((Project)project)).registerRunnableToRunOnAnyChange(new Runnable(){

            @Override
            public void run() {
                TypeInferenceHelper.this.myCalculatedTypeInferences.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiType getInferredType(GrReferenceExpression refExpr) {
        GroovyPsiElement scope = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)refExpr, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class, GrClassInitializer.class, GroovyFileBase.class});
        if (scope instanceof GrMethod) {
            scope = ((GrMethod)scope).getBlock();
        } else if (scope instanceof GrClassInitializer) {
            scope = ((GrClassInitializer)scope).getBlock();
        }
        if (scope != null) {
            HashSet scopes = myScopesBeingInferred.get();
            if (scopes == null) {
                scopes = new HashSet();
                myScopesBeingInferred.set((Set<GroovyPsiElement>)scopes);
            }
            if (scopes.contains(scope)) {
                return this.getTypeBinding(refExpr);
            }
            try {
                scopes.add(scope);
                Map<GrReferenceExpression, PsiType> map = (Map<GrReferenceExpression, PsiType>)this.myCalculatedTypeInferences.get((Object)scope);
                if (map == null) {
                    map = this.inferTypes((GrControlFlowOwner)scope);
                    this.myCalculatedTypeInferences.put((Object)scope, map);
                }
                PsiType psiType = (PsiType)map.get(refExpr);
                return psiType;
            }
            finally {
                scopes.remove(scope);
            }
        }
        return null;
    }

    public PsiType doWithInferenceDisabled(Computable<PsiType> computable) {
        return this.doInference(computable, Collections.<String, PsiType>emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiType doInference(Computable<PsiType> computable, @NotNull Map<String, PsiType> bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/TypeInferenceHelper.doInference must not be null");
        }
        Map<String, PsiType> oldBindings = myCurrentEnvironment.get();
        try {
            myCurrentEnvironment.set(bindings);
            PsiType psiType = (PsiType)computable.compute();
            return psiType;
        }
        finally {
            myCurrentEnvironment.set(oldBindings);
        }
    }

    public PsiType getTypeBinding(GrReferenceExpression refExpr) {
        if (refExpr.getQualifierExpression() == null) {
            String refName = refExpr.getReferenceName();
            Map<String, PsiType> env = myCurrentEnvironment.get();
            if (env != null) {
                return env.get(refName);
            }
        }
        return null;
    }

    private Map<GrReferenceExpression, PsiType> inferTypes(GrControlFlowOwner owner) {
        Instruction[] flow = owner.getControlFlow();
        TypeDfaInstance dfaInstance = new TypeDfaInstance();
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
        DFAEngine<Map<String, PsiType>> engine = new DFAEngine<Map<String, PsiType>>(flow, dfaInstance, semilattice);
        ArrayList<Map<String, PsiType>> infos = engine.performDFA();
        HashMap result = new HashMap();
        for (int i = 0; i < flow.length; ++i) {
            PsiType type;
            String refName;
            GrReferenceExpression ref;
            Instruction instruction = flow[i];
            PsiElement element = instruction.getElement();
            if (!(element instanceof GrReferenceExpression) || (ref = (GrReferenceExpression)element).getQualifierExpression() != null || (refName = ref.getReferenceName()) == null || (type = infos.get(i).get(refName)) == null) continue;
            result.put(ref, type);
        }
        return result;
    }
}

