/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyCacheUtil;

class GroovyDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(DirectClassInheritorsSearch.SearchParameters queryParameters, Processor<PsiClass> consumer) {
        final PsiClass clazz = queryParameters.getClassToProcess();
        final SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            PsiClass[] candidates;
            for (final PsiClass candidate : candidates = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                public PsiClass[] compute() {
                    if (!clazz.isValid()) {
                        return PsiClass.EMPTY_ARRAY;
                    }
                    return GroovyCacheUtil.getDeriverCandidates(clazz, (GlobalSearchScope)scope);
                }
            })) {
                boolean isInheritor = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return candidate.isInheritor(clazz, false);
                    }
                });
                if (!isInheritor || consumer.process((Object)candidate)) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

