/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.modifiers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class ThrowsFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        PsiElement candidate = null;
        if (GroovyCompletionUtil.isInTypeDefinitionBody(context)) {
            PsiElement run = context;
            while (!(run.getParent() instanceof GrTypeDefinitionBody)) {
                run = run.getParent();
                assert (run != null);
            }
            candidate = PsiTreeUtil.getPrevSiblingOfType((PsiElement)run, GrMember.class);
        } else if (context.getParent() instanceof PsiErrorElement) {
            candidate = context.getParent().getPrevSibling();
        }
        return candidate instanceof GrMethod && ((GrMethod)candidate).getBlock() == null;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "'throws' keyword filter";
    }
}

