/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.utils;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public class TreeUtil {
    private TreeUtil() {
    }

    @Nullable
    public static PsiElement getNextLeaf(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement sibling = element.getNextSibling();
        if (sibling == null) {
            PsiElement parent = element.getParent();
            return TreeUtil.getNextLeaf(parent);
        }
        return TreeUtil.getFirstLeaf(sibling);
    }

    private static PsiElement getFirstLeaf(PsiElement element) {
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            return element;
        }
        return TreeUtil.getFirstLeaf(children[0]);
    }

    @Nullable
    public static PsiElement getPrevLeaf(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement sibling = element.getPrevSibling();
        if (sibling == null) {
            PsiElement parent = element.getParent();
            return TreeUtil.getPrevLeaf(parent);
        }
        return TreeUtil.getLastLeaf(sibling);
    }

    private static PsiElement getLastLeaf(PsiElement element) {
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            return element;
        }
        return TreeUtil.getLastLeaf(children[children.length - 1]);
    }
}

