/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.gant.AntTasksProvider;
import org.jetbrains.plugins.groovy.gant.GantIcons;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;

public class GantTargetReference
implements PsiPolyVariantReference {
    @NotNull
    private final GrReferenceExpression myRefExpr;

    public GantTargetReference(@NotNull GrReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantTargetReference.<init> must not be null");
        }
        this.myRefExpr = refExpr;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String capitalized;
        Set<String> tasks;
        ResolveResult[] resolveResultArray;
        if (this.myRefExpr.getQualifierExpression() != null) {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
            if (ResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.multiResolve must not return null");
            return resolveResultArray;
        }
        PsiElement parent = this.myRefExpr.getParent();
        if (!(parent instanceof GrCall)) {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
            if (ResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.multiResolve must not return null");
            return resolveResultArray;
        }
        PsiFile file = this.myRefExpr.getContainingFile();
        if (!GantUtils.isGantScriptFile(file)) {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
            if (ResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.multiResolve must not return null");
            return resolveResultArray;
        }
        ArrayList<GroovyResolveResultImpl> res = new ArrayList<GroovyResolveResultImpl>();
        GroovyFile groovyFile = (GroovyFile)file;
        for (GrArgumentLabel label : GantUtils.getScriptTargets(groovyFile)) {
            String name = label.getName();
            if (name == null || !name.equals(this.myRefExpr.getName())) continue;
            res.add(new GroovyResolveResultImpl(label, true));
        }
        Project project = groovyFile.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myRefExpr.getProject());
        PsiClass taskClass = facade.findClass("org.apache.tools.ant.Task", GlobalSearchScope.allScope((Project)project));
        String name = this.myRefExpr.getName();
        if (name != null && taskClass != null && (tasks = AntTasksProvider.getInstance(project).getAntTasks()).contains(capitalized = StringUtil.capitalize((String)name))) {
            PsiClass[] classes;
            for (PsiClass clazz : classes = facade.getShortNamesCache().getClassesByName(capitalized, GlobalSearchScope.allScope((Project)project))) {
                if (!clazz.isInheritor(taskClass, true)) continue;
                res.add(new GroovyResolveResultImpl((PsiElement)clazz, true));
            }
        }
        if ((resolveResultArray = res.toArray(new ResolveResult[res.size()])) != null) return resolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.multiResolve must not return null");
    }

    @NotNull
    public GrReferenceExpression getElement() {
        GrReferenceExpression grReferenceExpression = this.myRefExpr;
        if (grReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.getElement must not return null");
        }
        return grReferenceExpression;
    }

    public TextRange getRangeInElement() {
        return this.getElement().getRangeInElement();
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    public String getCanonicalText() {
        return this.myRefExpr.getCanonicalText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myRefExpr.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantTargetReference.bindToElement must not be null");
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    public LookupElement[] getScriptTargets() {
        ArrayList<LookupElementBuilder> pageProperties = new ArrayList<LookupElementBuilder>();
        PsiFile file = this.myRefExpr.getContainingFile();
        if (GantUtils.isGantScriptFile(file)) {
            GroovyFile groovyFile = (GroovyFile)file;
            for (GrArgumentLabel label : GantUtils.getScriptTargets(groovyFile)) {
                String name = label.getName();
                if (name == null) continue;
                pageProperties.add(LookupElementBuilder.create((String)name).setIcon(GantIcons.GANT_TASK));
            }
            for (String taskName : AntTasksProvider.getInstance(file.getProject()).getAntTasks()) {
                String name = StringUtil.decapitalize((String)taskName);
                pageProperties.add(LookupElementBuilder.create((String)name).setIcon(GantIcons.ANT_TASK));
            }
        }
        return pageProperties.toArray(new LookupElement[pageProperties.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        GrExpression qualifier = this.myRefExpr.getQualifierExpression();
        if (qualifier == null && !(this.myRefExpr.getParent() instanceof GrReferenceExpression)) {
            objectArray = this.getScriptTargets();
            if (objectArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.getVariants must not return null");
            return objectArray;
        }
        objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        if (ArrayUtil.EMPTY_OBJECT_ARRAY != null) return objectArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantTargetReference.getVariants must not return null");
    }

    public boolean isSoft() {
        return false;
    }
}

