/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.util.TestNGUtil;

public class TestClassFilter
implements TreeClassChooser.ClassFilterWithScope {
    private final GlobalSearchScope scope;
    private final Project project;
    private final boolean includeConfig;

    public TestClassFilter(GlobalSearchScope scope, Project project, boolean includeConfig) {
        this.scope = scope;
        this.project = project;
        this.includeConfig = includeConfig;
    }

    public TestClassFilter intersectionWith(GlobalSearchScope scope) {
        return new TestClassFilter(this.scope.intersectWith(scope), this.project, this.includeConfig);
    }

    public boolean isAccepted(PsiClass psiClass) {
        if (!ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS.value((Object)psiClass)) {
            return false;
        }
        boolean hasTest = TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
        if (hasTest) {
            return true;
        }
        return this.includeConfig && TestNGUtil.hasConfig((PsiModifierListOwner)psiClass);
    }

    public Project getProject() {
        return this.project;
    }

    public GlobalSearchScope getScope() {
        return this.scope;
    }
}

