/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.annotate;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.Annotation;
import com.intellij.cvsSupport2.cvsstatuses.CvsEntriesListener;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.vcs.annotate.AnnotationListener;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CvsFileAnnotation
implements FileAnnotation {
    private final String myContent;
    private final Annotation[] myAnnotations;
    private final CvsEntriesListener myCvsEntriesListener;
    private final Map<String, String> myRevisionComments = new HashMap<String, String>();
    @Nullable
    private final List<VcsFileRevision> myRevisions;
    private final VirtualFile myFile;
    private final List<AnnotationListener> myListeners = new ArrayList<AnnotationListener>();
    private final LineAnnotationAspect USER = new LineAnnotationAspectAdapter(){

        public String getValue(int lineNumber) {
            if (lineNumber < 0 || lineNumber >= CvsFileAnnotation.this.myAnnotations.length) {
                return "";
            }
            return CvsFileAnnotation.this.myAnnotations[lineNumber].getUserName();
        }
    };
    private final LineAnnotationAspect DATE = new LineAnnotationAspectAdapter(){

        public String getValue(int lineNumber) {
            if (lineNumber < 0 || lineNumber >= CvsFileAnnotation.this.myAnnotations.length) {
                return "";
            }
            return CvsFileAnnotation.this.myAnnotations[lineNumber].getPresentableDateString();
        }
    };
    private final LineAnnotationAspect REVISION = new LineAnnotationAspectAdapter(){

        public String getValue(int lineNumber) {
            if (lineNumber < 0 || lineNumber >= CvsFileAnnotation.this.myAnnotations.length) {
                return "";
            }
            return CvsFileAnnotation.this.myAnnotations[lineNumber].getRevision();
        }
    };

    public CvsFileAnnotation(String content, Annotation[] annotations, @Nullable List<VcsFileRevision> revisions, VirtualFile file) {
        this.myContent = content;
        this.myAnnotations = annotations;
        this.myRevisions = revisions;
        this.myFile = file;
        if (revisions != null) {
            for (VcsFileRevision revision : revisions) {
                this.myRevisionComments.put(revision.getRevisionNumber().toString(), revision.getCommitMessage());
            }
            Collections.sort(this.myRevisions, new Comparator<VcsFileRevision>(){

                @Override
                public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                    return -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
                }
            });
        }
        this.myCvsEntriesListener = new CvsEntriesListener(){

            @Override
            public void entriesChanged(VirtualFile parent) {
            }

            private void fireAnnotationChanged() {
                AnnotationListener[] listeners;
                for (AnnotationListener listener : listeners = CvsFileAnnotation.this.myListeners.toArray(new AnnotationListener[CvsFileAnnotation.this.myListeners.size()])) {
                    listener.onAnnotationChanged();
                }
            }

            @Override
            public void entryChanged(VirtualFile file) {
                if (CvsFileAnnotation.this.myFile == null) {
                    return;
                }
                this.fireAnnotationChanged();
            }
        };
        CvsEntriesManager.getInstance().addCvsEntriesListener(this.myCvsEntriesListener);
    }

    public void addListener(AnnotationListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(AnnotationListener listener) {
        this.myListeners.remove(listener);
    }

    public void dispose() {
        CvsEntriesManager.getInstance().removeCvsEntriesListener(this.myCvsEntriesListener);
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION, this.DATE, this.USER};
    }

    public String getToolTip(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myAnnotations.length) {
            return "";
        }
        String revision = this.myAnnotations[lineNumber].getRevision();
        String comment = this.myRevisionComments.get(revision);
        if (comment == null) {
            return "";
        }
        return CvsBundle.message((String)"annotation.tooltip", (Object[])new Object[]{revision, comment});
    }

    public String getAnnotatedContent() {
        return this.myContent;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myAnnotations.length) {
            return null;
        }
        String revision = this.myAnnotations[lineNumber].getRevision();
        if (revision != null) {
            return new CvsRevisionNumber(revision);
        }
        return null;
    }

    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public boolean revisionsNotEmpty() {
        return !this.myRevisions.isEmpty();
    }

    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }
}

