/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.ui.CopyrightProjectConfigurable;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import javax.swing.Icon;

public class GenerateCopyrightAction
extends AnAction {
    public void update(AnActionEvent event) {
        Editor editor;
        Presentation presentation = event.getPresentation();
        DataContext context = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(context);
        if (file == null && (editor = (Editor)PlatformDataKeys.EDITOR.getData(context)) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (file == null || !FileTypeUtil.getInstance().isSupportedFile(file)) {
            presentation.setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext context = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        assert (project != null);
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(context);
        PsiFile file = null;
        if (editor != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == null) {
            return;
        }
        if (CopyrightManager.getInstance(project).getCopyrightOptions(file) == null) {
            if (Messages.showOkCancelDialog((Project)project, (String)"No copyright configured for current file. Would you like to edit copyright settings?", (String)"No copyright available", (Icon)Messages.getQuestionIcon()) == 0) {
                CopyrightProjectConfigurable projectConfigurable = (CopyrightProjectConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, CopyrightProjectConfigurable.class);
                ShowSettingsUtil.getInstance().showSettingsDialog(project, (Configurable)projectConfigurable);
            } else {
                return;
            }
        }
        new UpdateCopyrightProcessor(project, module, file).run();
    }
}

